/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.config.http.HttpSecurityBeanDefinitionParser;
import org.springframework.security.web.access.expression.DefaultWebSecurityExpressionHandler;
import org.springframework.security.web.access.expression.ExpressionBasedFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.DefaultFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.RequestKey;
import org.springframework.security.web.util.AntUrlPathMatcher;
import org.springframework.security.web.util.UrlMatcher;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterInvocationSecurityMetadataSourceParser
implements BeanDefinitionParser {
    private static final String ATT_USE_EXPRESSIONS = "use-expressions";
    private static final String ATT_HTTP_METHOD = "method";
    private static final String ATT_PATTERN = "pattern";
    private static final String ATT_ACCESS = "access";
    private static final Log logger = LogFactory.getLog(FilterInvocationSecurityMetadataSourceParser.class);

    @Override
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        List<Element> interceptUrls = DomUtils.getChildElementsByTagName(element, "intercept-url");
        for (Element elt : interceptUrls) {
            if (StringUtils.hasLength(elt.getAttribute("requires-channel"))) {
                parserContext.getReaderContext().error("The attribute 'requires-channel' isn't allowed here.", elt);
            }
            if (!StringUtils.hasLength(elt.getAttribute("filters"))) continue;
            parserContext.getReaderContext().error("The attribute 'filters' isn't allowed here.", elt);
        }
        BeanDefinition mds = FilterInvocationSecurityMetadataSourceParser.createSecurityMetadataSource(interceptUrls, element, parserContext);
        String id = element.getAttribute("id");
        if (StringUtils.hasText(id)) {
            parserContext.registerComponent(new BeanComponentDefinition(mds, id));
            parserContext.getRegistry().registerBeanDefinition(id, mds);
        }
        return mds;
    }

    static BeanDefinition createSecurityMetadataSource(List<Element> interceptUrls, Element elt, ParserContext pc) {
        BeanDefinitionBuilder fidsBuilder;
        UrlMatcher matcher = HttpSecurityBeanDefinitionParser.createUrlMatcher(elt);
        boolean useExpressions = FilterInvocationSecurityMetadataSourceParser.isUseExpressions(elt);
        ManagedMap<BeanDefinition, BeanDefinition> requestToAttributesMap = FilterInvocationSecurityMetadataSourceParser.parseInterceptUrlsForFilterInvocationRequestMap(interceptUrls, useExpressions, pc);
        if (useExpressions) {
            String expressionHandlerRef;
            Element expressionHandlerElt = DomUtils.getChildElementByTagName(elt, "expression-handler");
            String string = expressionHandlerRef = expressionHandlerElt == null ? null : expressionHandlerElt.getAttribute("ref");
            if (StringUtils.hasText(expressionHandlerRef)) {
                logger.info("Using bean '" + expressionHandlerRef + "' as web SecurityExpressionHandler implementation");
            } else {
                AbstractBeanDefinition expressionHandler = BeanDefinitionBuilder.rootBeanDefinition(DefaultWebSecurityExpressionHandler.class).getBeanDefinition();
                expressionHandlerRef = pc.getReaderContext().generateBeanName(expressionHandler);
                pc.registerBeanComponent(new BeanComponentDefinition(expressionHandler, expressionHandlerRef));
            }
            fidsBuilder = BeanDefinitionBuilder.rootBeanDefinition(ExpressionBasedFilterInvocationSecurityMetadataSource.class);
            fidsBuilder.addConstructorArgValue(matcher);
            fidsBuilder.addConstructorArgValue(requestToAttributesMap);
            fidsBuilder.addConstructorArgReference(expressionHandlerRef);
        } else {
            fidsBuilder = BeanDefinitionBuilder.rootBeanDefinition(DefaultFilterInvocationSecurityMetadataSource.class);
            fidsBuilder.addConstructorArgValue(matcher);
            fidsBuilder.addConstructorArgValue(requestToAttributesMap);
        }
        fidsBuilder.addPropertyValue("stripQueryStringFromUrls", matcher instanceof AntUrlPathMatcher);
        fidsBuilder.getRawBeanDefinition().setSource(pc.extractSource(elt));
        return fidsBuilder.getBeanDefinition();
    }

    static boolean isUseExpressions(Element elt) {
        return "true".equals(elt.getAttribute(ATT_USE_EXPRESSIONS));
    }

    private static ManagedMap<BeanDefinition, BeanDefinition> parseInterceptUrlsForFilterInvocationRequestMap(List<Element> urlElts, boolean useExpressions, ParserContext parserContext) {
        ManagedMap<BeanDefinition, BeanDefinition> filterInvocationDefinitionMap = new ManagedMap<BeanDefinition, BeanDefinition>();
        for (Element urlElt : urlElts) {
            String method;
            String access = urlElt.getAttribute(ATT_ACCESS);
            if (!StringUtils.hasText(access)) continue;
            String path = urlElt.getAttribute(ATT_PATTERN);
            if (!StringUtils.hasText(path)) {
                parserContext.getReaderContext().error("path attribute cannot be empty or null", urlElt);
            }
            if (!StringUtils.hasText(method = urlElt.getAttribute(ATT_HTTP_METHOD))) {
                method = null;
            }
            BeanDefinitionBuilder keyBldr = BeanDefinitionBuilder.rootBeanDefinition(RequestKey.class);
            keyBldr.addConstructorArgValue(path);
            keyBldr.addConstructorArgValue(method);
            BeanDefinitionBuilder attributeBuilder = BeanDefinitionBuilder.rootBeanDefinition(SecurityConfig.class);
            attributeBuilder.addConstructorArgValue(access);
            if (useExpressions) {
                logger.info("Creating access control expression attribute '" + access + "' for " + path);
                attributeBuilder.setFactoryMethod("createSingleAttributeList");
            } else {
                attributeBuilder.setFactoryMethod("createListFromCommaDelimitedString");
            }
            AbstractBeanDefinition key = keyBldr.getBeanDefinition();
            if (filterInvocationDefinitionMap.containsKey(key)) {
                logger.warn("Duplicate URL defined: " + path + ". The original attribute values will be overwritten");
            }
            filterInvocationDefinitionMap.put(key, attributeBuilder.getBeanDefinition());
        }
        return filterInvocationDefinitionMap;
    }
}

