/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.util;

import java.io.UnsupportedEncodingException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import org.springframework.core.NestedRuntimeException;
import org.springframework.security.core.codec.Base64;
import org.springframework.util.Assert;

@Deprecated
public final class EncryptionUtils {
    private EncryptionUtils() {
    }

    public static byte[] stringToByteArray(String input) {
        Assert.hasLength(input, "Input required");
        try {
            return input.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException fallbackToDefault) {
            return input.getBytes();
        }
    }

    public static String byteArrayToString(byte[] byteArray) {
        Assert.notNull(byteArray, "ByteArray required");
        Assert.isTrue(byteArray.length > 0, "ByteArray cannot be empty");
        try {
            return new String(byteArray, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            return new String(byteArray);
        }
    }

    private static byte[] cipher(String key, byte[] passedBytes, int cipherMode) throws EncryptionException {
        try {
            DESedeKeySpec keySpec = new DESedeKeySpec(EncryptionUtils.stringToByteArray(key));
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESede");
            Cipher cipher = Cipher.getInstance("DESede/ECB/PKCS5Padding");
            SecretKey secretKey = keyFactory.generateSecret(keySpec);
            cipher.init(cipherMode, secretKey);
            return cipher.doFinal(passedBytes);
        }
        catch (Exception e) {
            throw new EncryptionException(e.getMessage(), e);
        }
    }

    public static String encrypt(String key, String inputString) throws EncryptionException {
        EncryptionUtils.isValidKey(key);
        byte[] cipherText = EncryptionUtils.cipher(key, EncryptionUtils.stringToByteArray(inputString), 1);
        return EncryptionUtils.byteArrayToString(Base64.encode(cipherText));
    }

    public static byte[] encrypt(String key, byte[] inputBytes) throws EncryptionException {
        EncryptionUtils.isValidKey(key);
        return Base64.encode(EncryptionUtils.cipher(key, inputBytes, 1));
    }

    public static String decrypt(String key, String inputString) throws EncryptionException {
        Assert.hasText(key, "A key is required to attempt decryption");
        byte[] cipherText = EncryptionUtils.cipher(key, Base64.decode(EncryptionUtils.stringToByteArray(inputString)), 2);
        return EncryptionUtils.byteArrayToString(cipherText);
    }

    public static byte[] decrypt(String key, byte[] inputBytes) throws EncryptionException {
        Assert.hasText(key, "A key is required to attempt decryption");
        return EncryptionUtils.cipher(key, Base64.decode(inputBytes), 2);
    }

    private static void isValidKey(String key) {
        Assert.hasText(key, "A key to perform the encryption is required");
        Assert.isTrue(key.length() >= 24, "Key must be at least 24 characters long");
    }

    public static class EncryptionException
    extends NestedRuntimeException {
        private static final long serialVersionUID = 1L;

        public EncryptionException(String message, Throwable t) {
            super(message, t);
        }

        public EncryptionException(String message) {
            super(message);
        }
    }
}

