/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication;

import java.io.IOException;
import java.util.LinkedHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.util.RequestMatcher;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingAuthenticationEntryPoint
implements AuthenticationEntryPoint,
InitializingBean {
    private LinkedHashMap<RequestMatcher, AuthenticationEntryPoint> entryPoints;
    private AuthenticationEntryPoint defaultEntryPoint;

    public DelegatingAuthenticationEntryPoint(LinkedHashMap<RequestMatcher, AuthenticationEntryPoint> entryPoints) {
        this.entryPoints = entryPoints;
    }

    public void setDefaultEntryPoint(AuthenticationEntryPoint defaultEntryPoint) {
        this.defaultEntryPoint = defaultEntryPoint;
    }

    @Override
    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        for (RequestMatcher requestMatcher : this.entryPoints.keySet()) {
            if (!requestMatcher.matches(request)) continue;
            this.entryPoints.get(requestMatcher).commence(request, response, authException);
            return;
        }
        this.defaultEntryPoint.commence(request, response, authException);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.notEmpty(this.entryPoints, "entryPoints must be specified");
        Assert.notNull(this.defaultEntryPoint, "defaultEntryPoint must be specified");
    }
}

