/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.preauth.websphere;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.authentication.AuthenticationDetailsSourceImpl;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.MutableGrantedAuthoritiesContainer;
import org.springframework.security.core.authority.mapping.Attributes2GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.SimpleAttributes2GrantedAuthoritiesMapper;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedGrantedAuthoritiesAuthenticationDetails;
import org.springframework.security.web.authentication.preauth.websphere.DefaultWASUsernameAndGroupsExtractor;
import org.springframework.security.web.authentication.preauth.websphere.WASUsernameAndGroupsExtractor;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSpherePreAuthenticatedAuthenticationDetailsSource
extends AuthenticationDetailsSourceImpl
implements InitializingBean {
    private final Log logger = LogFactory.getLog(this.getClass());
    private Attributes2GrantedAuthoritiesMapper webSphereGroups2GrantedAuthoritiesMapper = new SimpleAttributes2GrantedAuthoritiesMapper();
    private final WASUsernameAndGroupsExtractor wasHelper;

    public WebSpherePreAuthenticatedAuthenticationDetailsSource() {
        this(new DefaultWASUsernameAndGroupsExtractor());
    }

    WebSpherePreAuthenticatedAuthenticationDetailsSource(WASUsernameAndGroupsExtractor wasHelper) {
        super.setClazz(PreAuthenticatedGrantedAuthoritiesAuthenticationDetails.class);
        this.wasHelper = wasHelper;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.webSphereGroups2GrantedAuthoritiesMapper, "WebSphere groups to granted authorities mapper not set");
    }

    @Override
    public Object buildDetails(Object context) {
        Object result = super.buildDetails(context);
        if (result instanceof MutableGrantedAuthoritiesContainer) {
            ((MutableGrantedAuthoritiesContainer)result).setGrantedAuthorities(this.getWebSphereGroupsBasedGrantedAuthorities());
        }
        return result;
    }

    private List<GrantedAuthority> getWebSphereGroupsBasedGrantedAuthorities() {
        List<String> webSphereGroups = this.wasHelper.getGroupsForCurrentUser();
        List<GrantedAuthority> userGas = this.webSphereGroups2GrantedAuthoritiesMapper.getGrantedAuthorities(webSphereGroups);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("WebSphere groups: " + webSphereGroups + " mapped to Granted Authorities: " + userGas);
        }
        return userGas;
    }

    public void setWebSphereGroups2GrantedAuthoritiesMapper(Attributes2GrantedAuthoritiesMapper mapper) {
        this.webSphereGroups2GrantedAuthoritiesMapper = mapper;
    }
}

