/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.context;

import javax.servlet.ServletException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextPersistenceFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpSessionContextIntegrationFilter
extends SecurityContextPersistenceFilter
implements InitializingBean {
    public static final String SPRING_SECURITY_CONTEXT_KEY = "SPRING_SECURITY_CONTEXT";
    private Class<? extends SecurityContext> contextClass = SecurityContextImpl.class;
    private boolean allowSessionCreation = true;
    private boolean forceEagerSessionCreation = false;
    private boolean cloneFromHttpSession = false;
    private HttpSessionSecurityContextRepository repo = new HttpSessionSecurityContextRepository();

    public HttpSessionContextIntegrationFilter() throws ServletException {
        super.setSecurityContextRepository(this.repo);
    }

    public boolean isCloneFromHttpSession() {
        return this.cloneFromHttpSession;
    }

    public void setCloneFromHttpSession(boolean cloneFromHttpSession) {
        this.cloneFromHttpSession = cloneFromHttpSession;
        this.repo.setCloneFromHttpSession(cloneFromHttpSession);
    }

    public boolean isAllowSessionCreation() {
        return this.allowSessionCreation;
    }

    public void setAllowSessionCreation(boolean allowSessionCreation) {
        this.allowSessionCreation = allowSessionCreation;
        this.repo.setAllowSessionCreation(allowSessionCreation);
    }

    protected Class<? extends SecurityContext> getContextClass() {
        return this.contextClass;
    }

    public void setContextClass(Class secureContext) {
        this.contextClass = secureContext;
        this.repo.setSecurityContextClass(secureContext);
    }

    public boolean isForceEagerSessionCreation() {
        return this.forceEagerSessionCreation;
    }

    @Override
    public void setForceEagerSessionCreation(boolean forceEagerSessionCreation) {
        this.forceEagerSessionCreation = forceEagerSessionCreation;
        super.setForceEagerSessionCreation(forceEagerSessionCreation);
    }

    @Override
    public void afterPropertiesSet() {
        if (this.forceEagerSessionCreation && !this.allowSessionCreation) {
            throw new IllegalArgumentException("If using forceEagerSessionCreation, you must set allowSessionCreation to also be true");
        }
    }
}

