/*
 * Decompiled with CFR 0.152.
 */
package ucar.units;

import ucar.units.ConversionException;
import ucar.units.Converter;
import ucar.units.Unit;

public abstract class ConverterImpl
implements Converter {
    protected ConverterImpl(Unit fromUnit, Unit toUnit) throws ConversionException {
        if (!fromUnit.isCompatible(toUnit)) {
            throw new ConversionException(fromUnit, toUnit);
        }
    }

    public static Converter create(Unit fromUnit, Unit toUnit) throws ConversionException {
        return fromUnit.getConverterTo(toUnit);
    }

    public final float convert(float amount) {
        return (float)this.convert((double)amount);
    }

    public final float[] convert(float[] amounts) {
        return this.convert(amounts, new float[amounts.length]);
    }

    public final double[] convert(double[] amounts) {
        return this.convert(amounts, new double[amounts.length]);
    }
}

