/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossas.runbook;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.mapping.Mapping;
import com.xebialabs.deployit.mapper.artifact.ConfigurationFilesToHostMapper;
import com.xebialabs.deployit.mapper.artifact.GenericFolderToHostMapper;
import com.xebialabs.deployit.mapper.artifact.LibrariesToHostMapper;
import com.xebialabs.deployit.mapper.artifact.SqlFolderToDatabaseMapper;
import com.xebialabs.deployit.mapper.artifact.SqlScriptToDatabaseMapper;
import com.xebialabs.deployit.plugin.jbossas.ci.JBossasDeploymentStrategy;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasArtifactServerMapping;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasStartMode;
import com.xebialabs.deployit.plugin.jbossas.mapper.EarToJbossasServerMapper;
import com.xebialabs.deployit.plugin.jbossas.mapper.EjbJarToJbossasServerMapper;
import com.xebialabs.deployit.plugin.jbossas.mapper.JbossasDataSourceToJbossasServerMapper;
import com.xebialabs.deployit.plugin.jbossas.mapper.JbossasQueueToJbossasServerMapper;
import com.xebialabs.deployit.plugin.jbossas.mapper.JbossasTopicToJbossasServerMapper;
import com.xebialabs.deployit.plugin.jbossas.mapper.WarToJbossasServerMapper;
import com.xebialabs.deployit.plugin.jbossas.step.JbossasRestartServerStep;
import com.xebialabs.deployit.plugin.jbossas.step.JbossasStartServerStep;
import com.xebialabs.deployit.plugin.jbossas.step.JbossasStopServerStep;
import com.xebialabs.deployit.plugin.jbossas.step.JbossasWaitForDeploymentsToCompleteStep;
import com.xebialabs.deployit.util.SingleTypeHandlingRunBook;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbossasDeploymentRunBook
extends SingleTypeHandlingRunBook<Deployment> {
    public JbossasDeploymentRunBook() {
        super(Deployment.class);
    }

    protected void resolve(Change<Deployment> change, ChangePlan changePlan, List<Step> steps) {
        EjbJarToJbossasServerMapper ejbJarToServerMapper = new EjbJarToJbossasServerMapper(change);
        WarToJbossasServerMapper warToServerMapper = new WarToJbossasServerMapper(change);
        EarToJbossasServerMapper earToServerMapper = new EarToJbossasServerMapper(change);
        JbossasDataSourceToJbossasServerMapper dataSourceToServerMapper = new JbossasDataSourceToJbossasServerMapper(change);
        JbossasQueueToJbossasServerMapper queueToServerMapper = new JbossasQueueToJbossasServerMapper(change);
        JbossasTopicToJbossasServerMapper topicToServerMapper = new JbossasTopicToJbossasServerMapper(change);
        LibrariesToHostMapper librariesMapper = new LibrariesToHostMapper(change);
        GenericFolderToHostMapper genericFolderToHostMapper = new GenericFolderToHostMapper(change);
        ConfigurationFilesToHostMapper configurationFilesToHostMapper = new ConfigurationFilesToHostMapper(change);
        SqlFolderToDatabaseMapper sqlFoldermapper = new SqlFolderToDatabaseMapper(change);
        SqlScriptToDatabaseMapper sqlScriptMapper = new SqlScriptToDatabaseMapper(change);
        HashSet<JbossasServer> affectedServers = new HashSet<JbossasServer>();
        affectedServers.addAll(ejbJarToServerMapper.getAffectedTargets());
        affectedServers.addAll(warToServerMapper.getAffectedTargets());
        affectedServers.addAll(earToServerMapper.getAffectedTargets());
        affectedServers.addAll(dataSourceToServerMapper.getAffectedTargets());
        affectedServers.addAll(queueToServerMapper.getAffectedTargets());
        affectedServers.addAll(topicToServerMapper.getAffectedTargets());
        if (!this.isJbossasDeployment(ejbJarToServerMapper, warToServerMapper, earToServerMapper, dataSourceToServerMapper, queueToServerMapper, topicToServerMapper)) {
            return;
        }
        this.stopServers(affectedServers, steps);
        int lastStepCount = steps.size();
        earToServerMapper.generateDeletionSteps(steps);
        warToServerMapper.generateDeletionSteps(steps);
        ejbJarToServerMapper.generateDeletionSteps(steps);
        topicToServerMapper.generateDeletionSteps(steps);
        queueToServerMapper.generateDeletionSteps(steps);
        dataSourceToServerMapper.generateDeletionSteps(steps);
        configurationFilesToHostMapper.generateDeletionSteps(steps);
        librariesMapper.generateDeletionSteps(steps);
        genericFolderToHostMapper.generateDeletionSteps(steps);
        sqlFoldermapper.generateAdditionSteps(steps);
        sqlScriptMapper.generateAdditionSteps(steps);
        genericFolderToHostMapper.generateAdditionSteps(steps);
        librariesMapper.generateAdditionSteps(steps);
        configurationFilesToHostMapper.generateAdditionSteps(steps);
        dataSourceToServerMapper.generateAdditionSteps(steps);
        queueToServerMapper.generateAdditionSteps(steps);
        topicToServerMapper.generateAdditionSteps(steps);
        ejbJarToServerMapper.generateAdditionSteps(steps);
        warToServerMapper.generateAdditionSteps(steps);
        earToServerMapper.generateAdditionSteps(steps);
        if (steps.size() > lastStepCount) {
            this.startServers(this.getTargets(change), steps);
            this.waitForDeployments(affectedServers, steps);
        }
    }

    private Set<JbossasServer> getTargets(Change<Deployment> change) {
        TreeSet servers = Sets.newTreeSet((Comparator)new Comparator<JbossasServer>(){

            @Override
            public int compare(JbossasServer wlsTarget, JbossasServer wlsTarget1) {
                return wlsTarget.getName().compareTo(wlsTarget1.getName());
            }
        });
        this.getTargets(servers, (Deployment)change.getNewRevision());
        this.getTargets(servers, (Deployment)change.getOldRevision());
        return servers;
    }

    private void getTargets(Set<JbossasServer> targets, Deployment deployment) {
        if (deployment == null) {
            return;
        }
        for (Mapping m : deployment.getMappings()) {
            JbossasArtifactServerMapping mapping;
            if (!(m instanceof JbossasArtifactServerMapping) || !(mapping = (JbossasArtifactServerMapping)m).getDeploymentStrategy().equals((Object)JBossasDeploymentStrategy.DISABLED_HOT_DEPLOYMENT_STRATEGY)) continue;
            targets.add(mapping.getTarget());
        }
    }

    private void stopServers(Set<JbossasServer> affectedServers, List<Step> steps) {
        if (affectedServers.isEmpty()) {
            return;
        }
        for (JbossasServer server : affectedServers) {
            if (!JbossasStartMode.STOP_START.equals((Object)server.getStartMode())) continue;
            steps.add(new JbossasStopServerStep(server));
        }
    }

    private boolean isJbossasDeployment(EjbJarToJbossasServerMapper ejbJarToServerMapper, WarToJbossasServerMapper warToServerMapper, EarToJbossasServerMapper earToServerMapper, JbossasDataSourceToJbossasServerMapper dataSourceToServerMapper, JbossasQueueToJbossasServerMapper queueToServerMapper, JbossasTopicToJbossasServerMapper topicToServerMapper) {
        HashSet allServers = new HashSet();
        allServers.addAll(ejbJarToServerMapper.getAllTargets());
        allServers.addAll(warToServerMapper.getAllTargets());
        allServers.addAll(earToServerMapper.getAllTargets());
        allServers.addAll(dataSourceToServerMapper.getAllTargets());
        allServers.addAll(queueToServerMapper.getAllTargets());
        allServers.addAll(topicToServerMapper.getAllTargets());
        return !allServers.isEmpty();
    }

    private void startServers(Set<JbossasServer> servers, List<Step> steps) {
        if (servers.isEmpty()) {
            return;
        }
        for (JbossasServer eachServer : servers) {
            switch (eachServer.getStartMode()) {
                case RESTART: {
                    this.addRestartCommand(eachServer, steps);
                    break;
                }
                case STOP_START: {
                    steps.add(new JbossasStartServerStep(eachServer));
                }
            }
        }
    }

    private void waitForDeployments(Set<JbossasServer> servers, List<Step> steps) {
        int deploymentCompletionWaitTime = 0;
        for (JbossasServer eachServer : servers) {
            int completionWaitTime = eachServer.getDeploymentCompletionWaitTime();
            if (completionWaitTime <= deploymentCompletionWaitTime) continue;
            deploymentCompletionWaitTime = completionWaitTime;
        }
        if (deploymentCompletionWaitTime > 0) {
            steps.add(new JbossasWaitForDeploymentsToCompleteStep(deploymentCompletionWaitTime));
        }
    }

    protected void addRestartCommand(JbossasServer server, List<Step> steps) {
        switch (server.getVersion()) {
            case JBOSSAS_40: {
                steps.add(new JbossasRestartServerStep(server));
                break;
            }
            case JBOSSAS_50: 
            case JBOSSAS_60: {
                steps.add(new JbossasStopServerStep(server));
                steps.add(new JbossasWaitForDeploymentsToCompleteStep(server.getDeploymentCompletionWaitTime()));
                steps.add(new JbossasStartServerStep(server));
            }
        }
    }
}

