/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossas.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.ci.artifact.EjbJar;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileInputStreamTransformer;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.HostSessionFactory;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasArtifactServerMapping;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;
import com.xebialabs.deployit.plugin.jbossas.step.JbossasDeploymentStepBase;

public class JbossasDeployApplicationStep
extends JbossasDeploymentStepBase {
    public JbossasDeployApplicationStep(JbossasServer server, Ear ear, JbossasArtifactServerMapping mapping) {
        super(server, (NamedDeployableArtifact)ear, mapping);
        this.setDescription("Deploy EAR " + ear + " to JBoss server " + (Object)((Object)server));
    }

    public JbossasDeployApplicationStep(JbossasServer server, War war, JbossasArtifactServerMapping mapping) {
        super(server, (NamedDeployableArtifact)war, mapping);
        this.setDescription("Deploy WAR " + war + " to JBoss server " + (Object)((Object)server));
    }

    public JbossasDeployApplicationStep(JbossasServer server, EjbJar ejbJar, JbossasArtifactServerMapping mapping) {
        super(server, (NamedDeployableArtifact)ejbJar, mapping);
        this.setDescription("Deploy EJB " + ejbJar + " to JBoss server " + (Object)((Object)server));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession s = this.server.connectToAdminHost();
        try {
            boolean bl;
            HostSession ls = HostSessionFactory.getHostSession((Host)Host.getLocalHost());
            try {
                HostFile sourceFile = ls.getFile(this.artifact.getLocation());
                String artifactTargetFileName = this.getArtifactTargetFileName();
                HostFile tmpDir = s.getFile(this.server.getTmpDirPath());
                if (!tmpDir.exists()) {
                    ctx.logOutput(tmpDir + " does not exist, create it");
                    tmpDir.mkdirs();
                }
                HostFile targetTmpFile = tmpDir.getFile(artifactTargetFileName);
                ctx.logOutput("Copying application artifact to " + targetTmpFile.getPath() + " on " + this.server.getHost());
                HostFileUtils.copyFile((HostFile)sourceFile, (HostFile)targetTmpFile, (HostFileInputStreamTransformer)this.getTransformer());
                HostFile deployDir = s.getFile(this.server.getDeployDirPath());
                if (!deployDir.exists()) {
                    ctx.logOutput(deployDir + " does not exist, create it");
                    deployDir.mkdirs();
                }
                HostFile targetDeployFile = deployDir.getFile(artifactTargetFileName);
                ctx.logOutput("Moving application artifact from " + targetTmpFile.getPath() + " to " + targetDeployFile.getPath() + " on " + this.server.getHost());
                targetTmpFile.moveTo(targetDeployFile);
                ctx.logOutput("Done.");
                bl = true;
            }
            catch (Throwable throwable) {
                ls.close();
                throw throwable;
            }
            ls.close();
            return bl;
        }
        finally {
            s.close();
        }
    }
}

