/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.utils;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.qrmedia.commons.validation.ValidationUtils;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.plugin.tomcat.utils.BeanValueHandler;
import com.xebialabs.deployit.plugin.tomcat.utils.XmlBeanValueHandler;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CiToXML<T> {
    private final Set<String> addedAttributes;
    private final Map<String, String> translation = Maps.newHashMap();
    private final BeanValueHandler handler;
    private final T instance;
    private final Object[] emptyArgs = new Object[0];

    public CiToXML(T instance, Element e) {
        this.instance = instance;
        this.handler = new XmlBeanValueHandler(e);
        this.addedAttributes = Sets.newHashSet((Object[])new String[]{"class"});
    }

    public void process() {
        ValidationUtils.checkNotNull((String)"All arguments must be non-null", (Object[])new Object[]{this.instance});
        try {
            BeanInfo info = Introspector.getBeanInfo(this.instance.getClass());
            for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                String sValue;
                long lValue;
                int iValue;
                String propertyName = pd.getName();
                if (pd.getReadMethod() == null || this.isAlreadyAdded(propertyName)) continue;
                Object value = pd.getReadMethod().invoke(this.instance, this.emptyArgs);
                Class<Object> type = pd.getPropertyType();
                if ((type.isAssignableFrom(Integer.class) || "int".equals(type.toString())) && (iValue = ((Integer)value).intValue()) > 0) {
                    this.addAttribute(this.translate(propertyName), Integer.toString(iValue));
                }
                if ((type.isAssignableFrom(Long.class) || "long".equals(type.toString())) && (lValue = ((Long)value).longValue()) > 0L) {
                    this.addAttribute(this.translate(propertyName), Long.toString(lValue));
                }
                if (type.isAssignableFrom(String.class) && StringUtils.isNotBlank((String)(sValue = (String)value))) {
                    this.addAttribute(this.translate(propertyName), sValue);
                }
                if (!type.isAssignableFrom(Boolean.class) && !"boolean".equals(type.toString())) continue;
                Boolean bValue = (Boolean)value;
                this.addAttribute(this.translate(propertyName), bValue != false ? "true" : "false");
            }
        }
        catch (Exception e) {
            throw new ResolutionException("Error when process bean " + this.instance + " of class " + this.instance.getClass(), (Throwable)e);
        }
    }

    private boolean isAlreadyAdded(String propertyName) {
        for (String s : this.addedAttributes) {
            if (!s.equals(propertyName)) continue;
            return true;
        }
        return false;
    }

    public void addAttribute(String propertyName, String value) {
        if (this.isAlreadyAdded(propertyName)) {
            return;
        }
        this.handler.addAttribute(propertyName, value);
        this.addedAttributes.add(propertyName);
    }

    public void addTranslation(String beanPropertyName, String xmlPropertyName) {
        this.translation.put(beanPropertyName, xmlPropertyName);
    }

    private String translate(String propertyName) {
        if (this.translation.containsKey(propertyName)) {
            return this.translation.get(propertyName);
        }
        return propertyName;
    }
}

