/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.apache.httpd.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.apache.httpd.ci.ApacheHttpdServer;
import com.xebialabs.deployit.plugin.apache.httpd.step.AbstractApacheHttpdServerStep;

public class DestroyApacheHttpdVirtualHostStep
extends AbstractApacheHttpdServerStep {
    private String virtualHost;

    public DestroyApacheHttpdVirtualHostStep(ApacheHttpdServer apacheWebServer, String vhostDefinition) {
        super(apacheWebServer);
        this.virtualHost = vhostDefinition;
        this.setDescription("Destroy Apache HTTP Server virtual host " + this.virtualHost + " in Apache HTTP server " + (Object)((Object)apacheWebServer) + " on host " + apacheWebServer.getHost());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession hostSession = this.apacheHttpdServer.connectToAdminHost();
        try {
            String configFilePath = this.apacheHttpdServer.getConfFilePathForVirtualHost(this.virtualHost);
            ctx.logOutput("Deleting virtualhost config file " + configFilePath);
            HostFile configFile = hostSession.getFile(configFilePath);
            configFile.delete();
            String htdocsDirPath = this.apacheHttpdServer.getHtdocsDirPathForVirtualHost(this.virtualHost);
            ctx.logOutput("Deleting htdocs directory " + htdocsDirPath);
            HostFile htdocsDir = hostSession.getFile(htdocsDirPath);
            htdocsDir.deleteRecursively();
            boolean bl = true;
            return bl;
        }
        finally {
            hostSession.close();
        }
    }
}

