/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.ci;

import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.Discoverable;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.plugin.was.ci.WasDeploymentManager;
import com.xebialabs.deployit.plugin.was.ci.WasNodeAgent;
import com.xebialabs.deployit.plugin.was.ci.WasServer;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerApplicationServerPropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerErrorStreamRedirectPropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerJavaProcessPropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerJavaVirtualMachinePropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerOutputRedirectPropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerOutputStreamRedirectPropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerProcessExecutionPropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerSessionManagerDefaultCookiePropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerSessionManagerPropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerTuningPropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerWebContainerPropertiesStep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConfigurationItem(category="middleware", description="A WebSphere server managed by a node that is part of a deployment manager (WAS ND)", discoverable=true)
public class WasManagedServer
extends WasServer
implements Discoverable<WasManagedServer> {
    @ConfigurationItemProperty(asContainment=true, label="WebSphere node", description="Node on which the server runs")
    private WasNodeAgent node;

    public WasNodeAgent getNode() {
        return this.node;
    }

    public void setNode(WasNodeAgent node) {
        this.node = node;
    }

    @Override
    public WasDeploymentManager getCell() {
        return this.getNode().getCell();
    }

    @Override
    public Collection<WasNodeAgent> getNodes() {
        return Collections.singleton(this.getNode());
    }

    public WasManagedServer discover(Map<String, Object> info, ChangePlan cp) {
        List<Step> steps = this.getCheckSteps();
        cp.addSteps(steps);
        cp.execute(info);
        return this;
    }

    private List<Step> getCheckSteps() {
        ArrayList<Step> steps = new ArrayList<Step>();
        steps.add(new RetrieveWasServerApplicationServerPropertiesStep(this));
        steps.add(new RetrieveWasServerErrorStreamRedirectPropertiesStep(this));
        steps.add(new RetrieveWasServerJavaProcessPropertiesStep(this));
        steps.add(new RetrieveWasServerJavaVirtualMachinePropertiesStep(this));
        steps.add(new RetrieveWasServerOutputRedirectPropertiesStep(this));
        steps.add(new RetrieveWasServerOutputStreamRedirectPropertiesStep(this));
        steps.add(new RetrieveWasServerProcessExecutionPropertiesStep(this));
        steps.add(new RetrieveWasServerSessionManagerDefaultCookiePropertiesStep(this));
        steps.add(new RetrieveWasServerSessionManagerPropertiesStep(this));
        steps.add(new RetrieveWasServerTuningPropertiesStep(this));
        steps.add(new RetrieveWasServerWebContainerPropertiesStep(this));
        return steps;
    }

    public WasManagedServer discoverChildrenInfo(Map<String, Object> info, ChangePlan cp) {
        return null;
    }

    @Override
    public String getWasConfigIdType() {
        return "Server";
    }

    @Override
    public String getWasTargetType() {
        return "server";
    }

    @Override
    public String getShortTypeDescription() {
        return "managed server";
    }

    @Override
    public String getNodeName() {
        return this.getNode().getName();
    }
}

