/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.ci;

import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.Discoverable;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import com.xebialabs.deployit.plugin.was.ci.WasCellConfigurationExecutor;
import com.xebialabs.deployit.plugin.was.ci.WasNode;
import com.xebialabs.deployit.plugin.was.ci.WasNodeAgent;
import com.xebialabs.deployit.plugin.was.ci.WasServer;
import com.xebialabs.deployit.plugin.was.ci.WasVersion;
import com.xebialabs.deployit.plugin.was.step.CheckWasAdminAvailableStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasCellNameStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerApplicationServerPropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerErrorStreamRedirectPropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerJavaProcessPropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerJavaVirtualMachinePropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerOutputRedirectPropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerOutputStreamRedirectPropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerProcessExecutionPropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerSessionManagerDefaultCookiePropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerSessionManagerPropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerTuningPropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerWebContainerPropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasSubtypesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasUnmanagedServerNameBySoapPortStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasVersionStep;
import com.xebialabs.deployit.step.CheckDirExistsStep;
import com.xebialabs.deployit.step.CheckFileExistenceStep;
import com.xebialabs.deployit.step.HostConnectionStep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConfigurationItem(category="middleware", description="An unmanaged WebSphere Applicaton Server (WAS Base/SA)", discoverable=true)
public class WasUnmanagedServer
extends WasServer
implements WasCell,
WasNode,
Discoverable<WasUnmanagedServer> {
    @ConfigurationItemProperty(required=true, asContainment=true, description="Host on which the unmanaged WAS server runs")
    private Host host;
    @ConfigurationItemProperty(required=true, label="WebSphere cell name", identifying=true, description="Name of the WebSphere cell, e.g. MyCell, WASCell, Cell01")
    private String cellName;
    @ConfigurationItemProperty(required=true, label="WebSphere node name", identifying=true, description="Name of the WebSphere node")
    private String nodeName;
    @ConfigurationItemProperty(required=true, label="WebSphere Installation Path", description="Root path of the WebSphere installation path. e.g. /opt/ws/6.1/appserver/profiles/AppSrv01", size=ConfigurationItemProperty.Size.LARGE, discoveryParam=true)
    private String wasHome;
    @ConfigurationItemProperty(required=false, label="Administrative port", description="TCP port which is used to login to the WebSphere Administration, default is 8880", discoveryParam=true)
    private int port;
    @ConfigurationItemProperty(required=false, label="Administrative username", description="Username which is used to login to the WebSphere Administration.", discoveryParam=true)
    private String username;
    @ConfigurationItemProperty(required=false, label="Administrative password", description="Password which is used to login to the WebSphere Administration.", password=true, discoveryParam=true)
    private String password;
    @ConfigurationItemProperty(required=true, label="WAS version", description="Version of WebSphere Application Server.")
    private WasVersion version;
    @ConfigurationItemProperty(required=false, label="Resource environment jndi names")
    private Set<String> resourceEnvironmentJndiNames = new HashSet<String>();
    protected transient WasCellConfigurationExecutor executor;

    private WasCellConfigurationExecutor getWasCellConfigurationExecutor() {
        if (this.executor == null) {
            this.executor = new WasCellConfigurationExecutor(this);
        }
        return this.executor;
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    @Override
    public String getCellName() {
        return this.cellName;
    }

    @Override
    public void setCellName(String cellName) {
        this.cellName = cellName;
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getWasHome() {
        return this.wasHome;
    }

    @Override
    public void setWasHome(String wasHome) {
        this.wasHome = wasHome;
    }

    @Override
    public WasVersion getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(WasVersion version) {
        this.version = version;
    }

    @Override
    public WasCell getCell() {
        return this;
    }

    @Override
    public Host getCellHost() {
        return this.host;
    }

    @Override
    public Collection<WasNodeAgent> getNodes() {
        return Collections.emptySet();
    }

    @Override
    public HostSession connectToAdminHost() {
        return this.getWasCellConfigurationExecutor().connectToAdminHost();
    }

    @Override
    public int executeWsadminJythonScript(StepExecutionContext ctx, HostSession cellHostSession, String scriptPath, String ... args) {
        return this.getWasCellConfigurationExecutor().executeWsadminJythonScript(ctx, cellHostSession, scriptPath, args);
    }

    @Override
    public Map<String, String> getCellPropertiesInfo(StepExecutionContext ctx) {
        return this.getWasCellConfigurationExecutor().getCellPropertiesInfo(ctx);
    }

    @Override
    public String getConfigDirPath() {
        return this.getWasCellConfigurationExecutor().getConfigDirPath();
    }

    @Override
    public Map<String, String> getObjectInfo(StepExecutionContext ctx, String objectContainmentPath) {
        return this.getWasCellConfigurationExecutor().getObjectInfo(ctx, objectContainmentPath);
    }

    @Override
    public Map<String, String> getObjectInfoWithSubLevelByName(StepExecutionContext ctx, String objectContainmentPath, String subLevelName) {
        return this.getWasCellConfigurationExecutor().getObjectInfoWithSubLevelByName(ctx, objectContainmentPath, subLevelName);
    }

    @Override
    public Map<String, String> getObjectInfoWithSubLevelByType(StepExecutionContext ctx, String objectContainmentPath, String subLevelType) {
        return this.getWasCellConfigurationExecutor().getObjectInfoWithSubLevelByType(ctx, objectContainmentPath, subLevelType);
    }

    @Override
    public Map<String, String> getObjectInfoWithSubLevelByTypeAndName(StepExecutionContext ctx, String objectContainmentPath, String subLevelType, String subLevelName) {
        return this.getWasCellConfigurationExecutor().getObjectInfoWithSubLevelByTypeAndName(ctx, objectContainmentPath, subLevelType, subLevelName);
    }

    @Override
    public Collection<String> getObjectInfoWithSubLevelByTypeNamesOnly(StepExecutionContext ctx, String objectContainmentPath, String subLevelType) {
        return this.getWasCellConfigurationExecutor().getObjectInfoWithSubLevelByTypeNamesOnly(ctx, objectContainmentPath, subLevelType);
    }

    @Override
    public String getPluginFilePath() {
        return this.getWasCellConfigurationExecutor().getPluginFilePath();
    }

    @Override
    public String getVersionInfoPath() {
        return this.getWasCellConfigurationExecutor().getVersionInfoPath();
    }

    @Override
    public String getWsadminPath() {
        return this.getWasCellConfigurationExecutor().getWsadminPath();
    }

    @Override
    public String getWasConfigIdType() {
        return "Server";
    }

    @Override
    public String getWasTargetType() {
        return "server";
    }

    @Override
    public String getShortTypeDescription() {
        return "unmanaged server";
    }

    public WasUnmanagedServer discover(Map<String, Object> info, ChangePlan cp) {
        List<Step> steps = this.getCheckAndNodeAndServerSteps();
        cp.addSteps(steps);
        cp.execute(info);
        return this;
    }

    public WasUnmanagedServer discoverChildrenInfo(Map<String, Object> info, ChangePlan cp) {
        return null;
    }

    private List<Step> getCheckAndNodeAndServerSteps() {
        ArrayList<Step> steps = new ArrayList<Step>();
        steps.add((Step)new HostConnectionStep(this.getHost()));
        steps.add((Step)new CheckDirExistsStep(this.getHost(), this.getWasHome()));
        steps.add((Step)new CheckDirExistsStep(this.getHost(), this.getConfigDirPath()));
        steps.add((Step)new CheckFileExistenceStep(this.getHost(), this.getVersionInfoPath(), true, false, true));
        steps.add(new RetrieveWasVersionStep(this));
        steps.add((Step)new CheckFileExistenceStep(this.getHost(), this.getWsadminPath(), true, false, true));
        steps.add(new CheckWasAdminAvailableStep(this));
        steps.add(new RetrieveWasCellNameStep(this));
        steps.add(new RetrieveWasSubtypesStep(this));
        steps.add(new SetNodeNameStep());
        steps.add(new RetrieveWasUnmanagedServerNameBySoapPortStep(this));
        steps.add(new RetrieveWasServerApplicationServerPropertiesStep(this));
        steps.add(new RetrieveWasServerErrorStreamRedirectPropertiesStep(this));
        steps.add(new RetrieveWasServerJavaProcessPropertiesStep(this));
        steps.add(new RetrieveWasServerJavaVirtualMachinePropertiesStep(this));
        steps.add(new RetrieveWasServerOutputRedirectPropertiesStep(this));
        steps.add(new RetrieveWasServerOutputStreamRedirectPropertiesStep(this));
        steps.add(new RetrieveWasServerProcessExecutionPropertiesStep(this));
        steps.add(new RetrieveWasServerSessionManagerDefaultCookiePropertiesStep(this));
        steps.add(new RetrieveWasServerSessionManagerPropertiesStep(this));
        steps.add(new RetrieveWasServerTuningPropertiesStep(this));
        steps.add(new RetrieveWasServerWebContainerPropertiesStep(this));
        return steps;
    }

    @Override
    public String getStartServerPath() {
        return this.getWasCellConfigurationExecutor().getStartServerPath();
    }

    @Override
    public String getStopServerPath() {
        return this.getWasCellConfigurationExecutor().getStopServerPath();
    }

    @Override
    public String getServerStatusPath() {
        return this.getWasCellConfigurationExecutor().getServerStatusPath();
    }

    public Set<String> getResourceEnvironmentJndiNames() {
        return this.resourceEnvironmentJndiNames;
    }

    public void setResourceEnvironmentJndiNames(Set<String> resourceEnvironmentJndiNames) {
        this.resourceEnvironmentJndiNames = resourceEnvironmentJndiNames;
    }

    class SetNodeNameStep
    implements Step {
        SetNodeNameStep() {
        }

        public boolean execute(StepExecutionContext ctx) {
            if (ctx.getAttribute("WasNode") != null) {
                Collection nodeNames = (Collection)ctx.getAttribute("WasNode");
                if (nodeNames.size() != 1) {
                    throw new ResolutionException(WasUnmanagedServer.this.getShortTypeDescription() + " can only contain one node and not " + nodeNames.size());
                }
                WasUnmanagedServer.this.setNodeName((String)nodeNames.iterator().next());
                return true;
            }
            ctx.logError("Unable to find nodename");
            return false;
        }

        public String getDescription() {
            return "Setting Nodename";
        }
    }
}

