/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.mapper;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.ModificationSupportingMappingAgnosticStepGeneratingMapper;
import com.xebialabs.deployit.plugin.wls.ci.WlsJmsQueue;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.plugin.wls.ci.WlsServerResourceMapping;
import com.xebialabs.deployit.plugin.wls.mapper.JmsMapperUtils;
import com.xebialabs.deployit.plugin.wls.step.CreateWlsJmsQueueStep;
import com.xebialabs.deployit.plugin.wls.step.DestroyWlsJmsQueueStep;
import com.xebialabs.deployit.plugin.wls.step.ModifyWlsJmsQueueStep;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WlsJmsQueueToWlsServerMapper
extends ModificationSupportingMappingAgnosticStepGeneratingMapper<WlsJmsQueue, WlsServerResourceMapping, WlsServer> {
    public WlsJmsQueueToWlsServerMapper(Change<Deployment> change) {
        super(change);
    }

    protected void generateAdditionStepsForAddedMapping(WlsJmsQueue queue, WlsServer server, List<Step> steps) {
        if (server.isRunningVersionGreaterThan9()) {
            this.checkErrorDestinationSuppliedWhenRedirectExpirationPolicy(queue);
            steps.add(new CreateWlsJmsQueueStep(server.getDomain(), JmsMapperUtils.getJmsModuleName((Change<Deployment>)this.change, server), queue));
        }
    }

    protected void generateModificationStepsForModifiedMapping(WlsJmsQueue oldQueue, WlsServer oldServer, WlsJmsQueue queue, WlsServer server, List<Step> steps) {
        if (server.isRunningVersionGreaterThan9()) {
            this.checkErrorDestinationSuppliedWhenRedirectExpirationPolicy(queue);
            steps.add(new ModifyWlsJmsQueueStep(server.getDomain(), JmsMapperUtils.getJmsModuleName((Change<Deployment>)this.change, server), queue));
        }
    }

    private void checkErrorDestinationSuppliedWhenRedirectExpirationPolicy(WlsJmsQueue queue) {
        if (ObjectUtils.equals((Object)((Object)queue.getExpirationPolicy()), (Object)((Object)WlsJmsQueue.ExpirationPolicy.REDIRECT)) && queue.getErrorQueue() == null) {
            throw new ResolutionException("Can not use 'Redirect' as message expiration policy if error destination is not defined for destination " + queue.getName());
        }
    }

    protected void generateDeletionStepsForDeletedMapping(WlsJmsQueue queue, WlsServer server, List<Step> steps) {
        if (server.isRunningVersionGreaterThan9()) {
            steps.add(new DestroyWlsJmsQueueStep(server.getDomain(), JmsMapperUtils.getJmsModuleName((Change<Deployment>)this.change, server), queue, server));
        }
    }
}

