#!/bin/sh
#
# Shell script to start Deployit
#

if [ "x$DEPLOYIT_HOME" = "x" ] ; then
  BIN_DIR=`dirname "$0"`
  cd "$BIN_DIR"
  ABSOLUTE_BIN_DIR=`pwd`
  DEPLOYIT_HOME=`dirname "$ABSOLUTE_BIN_DIR"`
fi
echo DEPLOYIT_HOME: $DEPLOYIT_HOME
cd "$DEPLOYIT_HOME"

DEPLOYIT_CONF=$DEPLOYIT_HOME/conf

deployitJar=bin/deployit-3.0-server.jar
pluginsDir=plugins
libDir=lib

if [ -z "$JAVA_HOME" ] ; then
  javaExec=java
else
  javaExec=${JAVA_HOME}/bin/java
fi

option=$1

deployitClassPath=$DEPLOYIT_CONF:$deployitJar

if [ "x$option" != "x-setup" ] && [ -d "${pluginsDir}" ]
then
  ls ${pluginsDir}/*.jar > /dev/null 2>&1
  if [ $? -eq 0 ]; then
    for pluginJar in `ls ${pluginsDir}/*.jar`
    do
      if [ -f $pluginJar ]; then
        deployitClassPath=${deployitClassPath}:${pluginJar}
      fi
    done
  fi
  ls ${pluginsDir}/* > /dev/null 2>&1

  if [ $? -eq 0 ]; then
    for expandedPluginDir in `ls ${pluginsDir}/*`
    do
      if [ -d $expandedPluginDir ]; then
        deployitClassPath=${deployitClassPath}:${expandedPluginDir}
      fi
    done
  fi

fi

# Search the DEPLOYIT_LIB for jar files and append these jars to deployitClassPath.

ls ${libDir}/*.jar > /dev/null 2>&1

if [ $? -eq 0 ]; then
  for libJar in `ls ${libDir}/*`
  do
    if [ -f $libJar ]; then
      deployitClassPath=${deployitClassPath}:${libJar}
    fi
  done
fi

$javaExec -classpath ${deployitClassPath} com.xebialabs.deployit.DeployIt "$@"
