/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.google.common.base.Strings;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.xebialabs.deployit.conversion.StringCoder;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class DeployitConfig {
    public static final String SPRING_CTX_CFG_LOCATION_KEY = "contextConfigLocation";
    public static final String SPRING_CONFIG = "classpath:spring/deployit-context.xml";
    public static final String DEFAULT_WEBCONTENT_PACKAGE = "web";
    public static final String DEFAULT_WEB_CONTEXT_ROOT = "/";
    public static final String KEY_USE_SSL = "ssl";
    public static final String KEY_SSL_PROTOCOL = "ssl.protocol";
    public static final String KEY_KEYSTORE_PATH = "keystore.path";
    public static final String KEY_KEYSTORE_PASSWORD = "keystore.password";
    public static final String KEY_KEYSTORE_KEYPASSWORD = "keystore.keypassword";
    public static final String KEY_HTTP_PORT = "http.port";
    public static final String KEY_WEB_CONTEXT_ROOT = "http.context.root";
    public static final String KEY_JCR_REPOSITORY_PATH = "jcr.repository.path";
    public static final String KEY_IMPORTABLE_PACKAGES_PATH = "importable.packages.path";
    public static final String KEY_MINIMUM_THREADS = "threads.min";
    public static final String KEY_MAXIMUM_THREADS = "threads.max";
    public static final String KEY_DEFAULT_PREFIX = "default.";
    public static final String KEY_CUSTOM_PREFIX = "custom.";
    public static String CONFIGURATION_FILENAME = "deployit.conf";
    private final File configFile;
    protected String keyStorePath;
    protected String keyStorePassword;
    protected String keyStoreKeyPassword;
    protected int httpPort;
    protected String jcrRepositoryPath;
    protected String importablePackagesPath;
    protected String administratorGroupName;
    protected boolean ssl;
    protected String sslProtocol;
    protected int minThreads;
    protected String webContextRoot = "/";
    protected int maxThreads;
    private Map<String, String> defaults = new HashMap<String, String>();
    private Map<String, String> customProperties = new HashMap<String, String>();
    private boolean newConfiguration = true;
    private static DeployitConfig instance;

    public int getMinThreads() {
        return this.minThreads;
    }

    public void setMinThreads(int minThreads) {
        this.minThreads = minThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public static synchronized DeployitConfig getInstance() {
        if (instance == null) {
            instance = new DeployitConfig();
        }
        return instance;
    }

    public DeployitConfig() {
        this.configFile = new File("conf", CONFIGURATION_FILENAME);
    }

    public boolean exists() {
        return this.configFile.exists();
    }

    public void load() {
        Properties properties = new Properties();
        FileInputStream inStream = null;
        try {
            inStream = (FileInputStream)Files.newInputStreamSupplier((File)this.configFile).getInput();
            properties.load(inStream);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(inStream);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)inStream);
        this.ssl = "true".equalsIgnoreCase(properties.getProperty(KEY_USE_SSL));
        this.sslProtocol = properties.getProperty(KEY_SSL_PROTOCOL);
        this.keyStorePath = properties.getProperty(KEY_KEYSTORE_PATH);
        this.keyStorePassword = properties.getProperty(KEY_KEYSTORE_PASSWORD);
        this.keyStoreKeyPassword = properties.getProperty(KEY_KEYSTORE_KEYPASSWORD);
        this.httpPort = this.parseIntSilent(properties, KEY_HTTP_PORT, this.httpPort);
        this.minThreads = this.parseIntSilent(properties, KEY_MINIMUM_THREADS, this.minThreads);
        this.maxThreads = this.parseIntSilent(properties, KEY_MAXIMUM_THREADS, this.maxThreads);
        this.jcrRepositoryPath = properties.getProperty(KEY_JCR_REPOSITORY_PATH);
        this.importablePackagesPath = properties.getProperty(KEY_IMPORTABLE_PACKAGES_PATH);
        this.webContextRoot = properties.getProperty(KEY_WEB_CONTEXT_ROOT, DEFAULT_WEB_CONTEXT_ROOT);
        this.defaults.clear();
        this.customProperties.clear();
        for (Map.Entry<Object, Object> each : properties.entrySet()) {
            String key = (String)each.getKey();
            String value = (String)each.getValue();
            if (key.startsWith(KEY_DEFAULT_PREFIX)) {
                this.defaults.put(key.substring(KEY_DEFAULT_PREFIX.length()).toLowerCase(), value);
            }
            if (!key.startsWith(KEY_CUSTOM_PREFIX)) continue;
            this.customProperties.put(key, value);
        }
        this.newConfiguration = false;
    }

    private int parseIntSilent(Properties properties, String KEY, int defaultValue) {
        try {
            return Integer.parseInt(properties.getProperty(KEY));
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public void save() {
        Properties properties = new Properties();
        properties.setProperty(KEY_USE_SSL, Boolean.toString(this.isSsl()));
        if (this.isSsl()) {
            properties.setProperty(KEY_KEYSTORE_PATH, this.getKeyStorePath());
            properties.setProperty(KEY_KEYSTORE_PASSWORD, this.keyStorePassword);
            properties.setProperty(KEY_KEYSTORE_KEYPASSWORD, this.keyStoreKeyPassword);
            if (this.getSslProtocol() != null) {
                properties.setProperty(KEY_SSL_PROTOCOL, this.getSslProtocol());
            }
        }
        properties.setProperty(KEY_HTTP_PORT, Integer.toString(this.getHttpPort()));
        properties.setProperty(KEY_WEB_CONTEXT_ROOT, this.webContextRoot);
        properties.setProperty(KEY_JCR_REPOSITORY_PATH, this.getJcrRepositoryPath());
        properties.setProperty(KEY_IMPORTABLE_PACKAGES_PATH, this.getImportablePackagesPath());
        properties.setProperty(KEY_MINIMUM_THREADS, Integer.toString(this.minThreads));
        properties.setProperty(KEY_MAXIMUM_THREADS, Integer.toString(this.maxThreads));
        for (Map.Entry<String, String> each : this.defaults.entrySet()) {
            properties.put(KEY_DEFAULT_PREFIX + each.getKey(), each.getValue());
        }
        properties.putAll(this.customProperties);
        FileOutputStream output = null;
        try {
            output = (FileOutputStream)Files.newOutputStreamSupplier((File)this.configFile).getOutput();
            properties.store(output, "Deployit configuration file.");
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(output);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)output);
    }

    public boolean isValid() {
        boolean valid = true;
        if (this.isSsl()) {
            if (this.isBlank(this.getKeyStorePath())) {
                System.err.println("keystore.path must be set.");
                valid = false;
            } else if (!new File(this.getKeyStorePath()).exists()) {
                System.err.println("keystore.path must point to an existing keystore.");
                valid = false;
            }
        }
        if (this.getHttpPort() < 1) {
            System.err.println("http.port is not valid, must be a number larger then 0");
            valid = false;
        }
        if (this.isBlank(this.webContextRoot)) {
            System.err.println("http.context.root must be set.");
            valid = false;
        }
        if (this.isBlank(this.getJcrRepositoryPath())) {
            System.err.println("jcr.repository.path must be set.");
            valid = false;
        }
        if (this.isBlank(this.getImportablePackagesPath())) {
            System.err.println("importable.packages.path must be set.");
            valid = false;
        }
        valid &= this.validateThatIntIsBiggerThen(KEY_MINIMUM_THREADS, this.getMinThreads(), 0);
        return valid &= this.validateThatIntIsBiggerThen(KEY_MAXIMUM_THREADS, this.getMaxThreads(), this.getMinThreads());
    }

    private boolean isBlank(String keyStorePath) {
        return Strings.nullToEmpty((String)keyStorePath).trim().isEmpty();
    }

    private boolean validateThatIntIsBiggerThen(String KEY, int intToValidate, int shouldBeBiggerThen) {
        if (intToValidate <= shouldBeBiggerThen) {
            System.err.println(KEY + " is not valid, must be a number larger then " + shouldBeBiggerThen);
            return false;
        }
        return true;
    }

    public static DeployitConfig loadForUse() {
        DeployitConfig configuration = DeployitConfig.getInstance();
        if (configuration.exists()) {
            configuration.load();
            if (!configuration.isValid()) {
                throw new Error("Configuration " + CONFIGURATION_FILENAME + " is not valid please run with -setup option.");
            }
        } else {
            throw new Error("Configuration " + CONFIGURATION_FILENAME + " does not exist, please run with -setup option before starting the server or command line interface.");
        }
        return configuration;
    }

    public boolean isNewConfiguration() {
        return this.newConfiguration;
    }

    public String getLocation() {
        return this.configFile.getAbsolutePath();
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    public String getKeyStorePassword() {
        return StringCoder.decode(this.keyStorePassword);
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = StringCoder.encode(keyStorePassword);
    }

    public String getKeyStoreKeyPassword() {
        return StringCoder.decode(this.keyStoreKeyPassword);
    }

    public void setKeyStoreKeyPassword(String keyStoreKeyPassword) {
        this.keyStoreKeyPassword = StringCoder.encode(keyStoreKeyPassword);
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public String getJcrRepositoryPath() {
        return this.jcrRepositoryPath;
    }

    public void setJcrRepositoryPath(String jcrRepositoryPath) {
        this.jcrRepositoryPath = jcrRepositoryPath;
    }

    public String getImportablePackagesPath() {
        return this.importablePackagesPath;
    }

    public void setImportablePackagesPath(String setImportablePackagesPath) {
        this.importablePackagesPath = setImportablePackagesPath;
    }

    public Map<String, String> getDefaults() {
        return this.defaults;
    }

    public void setDefaults(Map<String, String> defaults) {
        this.defaults = defaults;
    }

    public Map<String, String> getCustomProperties() {
        return this.customProperties;
    }

    public void setCustomProperties(Map<String, String> customProperties) {
        this.customProperties = customProperties;
    }

    public String getAdministratorGroupName() {
        return this.administratorGroupName;
    }

    public void setAdministratorGroupName(String administratorGroupName) {
        this.administratorGroupName = administratorGroupName;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public String getWebContextRoot() {
        return this.webContextRoot;
    }

    public void setWebContextRoot(String webContextRoot) {
        this.webContextRoot = webContextRoot;
    }
}

