/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jcr;

import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.RuntimeRepositoryException;
import com.xebialabs.deployit.security.AuthenticationFailureException;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.UsernameAndPasswordCredentials;
import java.io.IOException;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class JcrTemplate {
    private final Repository repository;
    private static final ThreadLocal<UserSession> SESSION_STORE = new ThreadLocal();
    private static final Logger logger = LoggerFactory.getLogger(JcrTemplate.class);

    @Autowired
    public JcrTemplate(Repository repository) {
        this.repository = repository;
    }

    public final <T> T executeAsAdmin(JcrCallback<T> callback) {
        return this.execute("admin", "admin", callback);
    }

    public final <T> T execute(JcrCallback<T> callback) {
        SecurityContext context = SecurityContextHolder.getContext();
        UsernameAndPasswordCredentials creds = (UsernameAndPasswordCredentials)context.getAuthentication();
        if (creds == null) {
            throw new AuthenticationFailureException();
        }
        return this.execute(creds.getUsername(), creds.getPassword(), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final <T> T execute(String username, String password, JcrCallback<T> callback) throws RuntimeIOException, RuntimeRepositoryException {
        UserSession userSession = SESSION_STORE.get();
        boolean createNewSession = false;
        if (userSession == null) {
            logger.debug("Did not find an existing session, creating a session for one JCR request.");
            createNewSession = true;
        } else if (!userSession.session.isLive()) {
            logger.debug("Existing session is no longer live, creating a session for one JCR request.");
            createNewSession = true;
        } else if (!userSession.username.equals(username)) {
            logger.debug("Existing session is for user {} instead of requested user {}, creating a session for one JCR request.", (Object)userSession.username, (Object)username);
            createNewSession = true;
        }
        if (createNewSession) {
            try {
                SimpleCredentials credentials = new SimpleCredentials(username, password.toCharArray());
                Session session = this.repository.login((Credentials)credentials);
                try {
                    T t = callback.doInJcr(session);
                    return t;
                }
                finally {
                    session.logout();
                }
            }
            catch (AccessDeniedException ade) {
                throw PermissionDeniedException.withMessage("Failed to complete your request.", (Exception)((Object)ade));
            }
            catch (LoginException le) {
                throw new AuthenticationFailureException(le, "Incorrect credentials for user %s", username);
            }
            catch (RepositoryException e) {
                throw new RuntimeRepositoryException(e.toString(), e);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
        try {
            return callback.doInJcr(userSession.session);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        catch (RepositoryException e) {
            throw new RuntimeRepositoryException(e.toString(), e);
        }
    }

    public void login() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (!(authentication instanceof UsernameAndPasswordCredentials)) {
            logger.error("Didn't get a UsernameAndPasswordCredentioals but a: {}", (Object)authentication);
            throw new AuthenticationFailureException("User was not yet logged in...");
        }
        UsernameAndPasswordCredentials creds = (UsernameAndPasswordCredentials)authentication;
        logger.debug("Logged in: {}", (Object)creds.getUsername());
        SimpleCredentials cred = new SimpleCredentials(creds.getUsername(), creds.getPassword().toCharArray());
        try {
            Session session = this.repository.login((Credentials)cred);
            SESSION_STORE.set(new UserSession(creds.getUsername(), session));
        }
        catch (AccessDeniedException ade) {
            throw PermissionDeniedException.withMessage("Failed to complete your request.", (Exception)((Object)ade));
        }
        catch (LoginException le) {
            throw new AuthenticationFailureException(le, "Incorrect credentials for user %s", creds.getUsername());
        }
        catch (RepositoryException e) {
            throw new RuntimeRepositoryException(e.toString(), e);
        }
    }

    public boolean isLoggedIn() {
        return SESSION_STORE.get() != null && SESSION_STORE.get().session.isLive();
    }

    public void logout() {
        if (SESSION_STORE.get() != null) {
            SESSION_STORE.get().session.logout();
            SESSION_STORE.remove();
        } else {
            logger.warn("Superfluous logout call found.", (Throwable)new RuntimeException());
        }
    }

    private static class UserSession {
        private String username;
        private Session session;

        private UserSession(String username, Session session) {
            this.username = username;
            this.session = session;
        }
    }
}

