/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.permission;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.repository.RepositoryServiceHolder;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PermissionHelper;
import com.xebialabs.deployit.security.permission.PrivilegesHelper;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PermissionHandler {
    protected static final String JCR_READ = "jcr:read";
    protected static final String JCR_ADD_CHILD_NODES = "jcr:addChildNodes";
    protected static final String JCR_NODE_TYPE_MANAGEMENT = "jcr:nodeTypeManagement";
    protected static final String JCR_VERSION_MANAGEMENT = "jcr:versionManagement";
    protected static final String JCR_MODIFY_PROPERTIES = "jcr:modifyProperties";
    protected static final String JCR_REMOVE_CHILD_NODES = "jcr:removeChildNodes";
    protected static final String JCR_REMOVE_NODE = "jcr:removeNode";
    protected static final List<String> ADD_CHILD_NODES_PRIVILEGES = Lists.newArrayList((Object[])new String[]{"jcr:read", "jcr:addChildNodes", "jcr:nodeTypeManagement", "jcr:versionManagement", "jcr:modifyProperties"});
    protected static final List<String> REMOVE_CHILD_NODES_PRIVILEGES = Lists.newArrayList((Object[])new String[]{"jcr:read", "jcr:removeChildNodes", "jcr:removeNode", "jcr:versionManagement", "jcr:modifyProperties"});
    private static final Logger logger = LoggerFactory.getLogger(PermissionHandler.class);

    public final void grant(String user, List<String> onConfigurationItems) {
        if (onConfigurationItems.isEmpty()) {
            this.handle(user, Action.GRANT);
        } else {
            for (String onConfigurationItem : onConfigurationItems) {
                if (RepositoryServiceHolder.getRepositoryService().checkNodeExists(onConfigurationItem)) {
                    this.handle(user, onConfigurationItem, Action.GRANT);
                    continue;
                }
                logger.warn("Skipping grant of {} to {} on {}", new Object[]{this.getPermission(), user, onConfigurationItem});
            }
        }
    }

    protected void handle(String user, Action action) {
        throw new Checks.IncorrectArgumentException("Cannot %s permission %s without any nodes", action.name(), this.getPermission().getPermissionName());
    }

    protected void handle(String user, String onConfigurationItem, Action action) {
        throw new Checks.IncorrectArgumentException("Cannot %s permission %s on nodes, it is a global permission", action.name(), this.getPermission().getPermissionName());
    }

    public final void revoke(String user, List<String> onConfigurationItems) {
        if (onConfigurationItems.isEmpty()) {
            if (PermissionHelper.hasPermission(this.getPermission())) {
                this.handle(user, Action.REVOKE);
            }
        } else {
            for (String onConfigurationItem : onConfigurationItems) {
                if (!PermissionHelper.hasPermission(this.getPermission(), user, onConfigurationItem)) continue;
                this.handle(user, onConfigurationItem, Action.REVOKE);
            }
        }
    }

    public void deny(String user, List<String> onConfigurationItems) {
        throw new Checks.IncorrectArgumentException("Cannot deny %s, only grant/revoke supported.", new Object[]{this.getPermission()});
    }

    abstract Permission getPermission();

    public final boolean hasPermission(List<String> onConfigurationItems) {
        return PermissionHelper.hasPermission(this.getPermission(), onConfigurationItems);
    }

    protected final void permission(Permission permission, String principal, Action action) {
        if (action == Action.GRANT) {
            PermissionHelper.grantPermission(permission, principal);
        } else if (action == Action.REVOKE) {
            PermissionHelper.revokePermission(permission, principal);
        }
    }

    protected final void permission(Permission permission, String principal, String onConfigurationItem, Action action) {
        if (action == Action.GRANT) {
            PermissionHelper.grantPermission(permission, principal, onConfigurationItem);
        } else if (action == Action.REVOKE) {
            PermissionHelper.revokePermission(permission, principal, onConfigurationItem);
        }
    }

    protected final void limitedPrivileges(List<String> privileges, String principal, String onConfigurationItem, Action action) {
        this.doPrivileges(privileges, principal, onConfigurationItem, action, false);
    }

    protected final void privileges(List<String> privileges, String principal, String onConfigurationItem, Action action) {
        this.doPrivileges(privileges, principal, onConfigurationItem, action, true);
    }

    private void doPrivileges(List<String> privileges, String principal, String onConfigurationItem, Action action, boolean transitive) {
        if (!RepositoryServiceHolder.getRepositoryService().checkNodeExists(onConfigurationItem)) {
            return;
        }
        if (action == Action.GRANT) {
            PrivilegesHelper.grantPrivileges(privileges, principal, onConfigurationItem, transitive);
        } else if (action == Action.REVOKE) {
            PrivilegesHelper.revokePrivileges(privileges, principal, onConfigurationItem, transitive);
        } else if (action == Action.DENY) {
            PrivilegesHelper.denyPrivileges(privileges, principal, onConfigurationItem, transitive);
        }
    }

    protected final void limitedPrivileges(List<String> privileges, String principal, Collection<String> onConfigurationItems, Action action) {
        for (String onConfigurationItem : onConfigurationItems) {
            this.limitedPrivileges(privileges, principal, onConfigurationItem, action);
        }
    }

    protected final void privileges(List<String> privileges, String principal, Collection<String> onConfigurationItems, Action action) {
        for (String onConfigurationItem : onConfigurationItems) {
            this.privileges(privileges, principal, onConfigurationItem, action);
        }
    }

    static enum Action {
        GRANT,
        REVOKE,
        DENY;

    }
}

