/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.permission;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.repository.RepositoryServiceHolder;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PermissionHandler;
import java.util.Collection;
import java.util.List;

public class UpgradeDeploymentHandler
extends PermissionHandler {
    @Override
    protected void handle(String user, PermissionHandler.Action action) {
        this.permission(Permission.DEPLOY_UPGRADE, user, action);
        this.privileges((List<String>)ADD_CHILD_NODES_PRIVILEGES, user, "Environments", action);
        this.privileges((List<String>)ADD_CHILD_NODES_PRIVILEGES, user, "Infrastructure", action);
        this.privileges((List<String>)REMOVE_CHILD_NODES_PRIVILEGES, user, "Infrastructure", action);
        this.privileges((List<String>)ADD_CHILD_NODES_PRIVILEGES, user, "tasks", action);
    }

    @Override
    protected void handle(String user, String onConfigurationItem, PermissionHandler.Action action) {
        Checks.checkArgument(onConfigurationItem.startsWith(Metadata.ConfigurationItemRoot.ENVIRONMENTS.getRootNodeName()), "%s is not an Environment", onConfigurationItem);
        this.permission(Permission.DEPLOY_UPGRADE, user, onConfigurationItem, action);
        this.privileges((List<String>)ADD_CHILD_NODES_PRIVILEGES, user, onConfigurationItem, action);
        Environment objectEntity = (Environment)RepositoryServiceHolder.getRepositoryService().read(onConfigurationItem);
        Collection members = Collections2.transform((Collection)objectEntity.getMembers(), (Function)new Function<Container, String>(){

            public String apply(Container input) {
                return input.getId();
            }
        });
        this.privileges((List<String>)ADD_CHILD_NODES_PRIVILEGES, user, members, action);
        this.privileges((List<String>)REMOVE_CHILD_NODES_PRIVILEGES, user, members, action);
        this.privileges((List<String>)ADD_CHILD_NODES_PRIVILEGES, user, "tasks", action);
    }

    @Override
    Permission getPermission() {
        return Permission.DEPLOY_UPGRADE;
    }
}

