/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.comparison;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.springframework.stereotype.Component;

@Component
public class Comparator {
    private static final String PASSWORD_OBFUSCATION = "********";

    public ListMultimap<String, String> compare(ConfigurationItem reference, List<ConfigurationItem> entities) {
        ComputingLinkedMap comparison = new ComputingLinkedMap(entities.size() + 1);
        this.checkCiTypes(reference.getType(), entities);
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)reference.getType());
        int nrCi = 0;
        ArrayList entitiesToCompare = Lists.newArrayList();
        entitiesToCompare.add(reference);
        entitiesToCompare.addAll(entities);
        for (ConfigurationItem compareEntity : entitiesToCompare) {
            this.writeFields(comparison, compareEntity, nrCi);
            this.writeProperties(comparison, compareEntity, descriptor, nrCi);
            ++nrCi;
        }
        LinkedListMultimap retval = LinkedListMultimap.create();
        for (String k : comparison.keySet()) {
            retval.putAll((Object)k, (Iterable)comparison.get(k));
        }
        return retval;
    }

    private void writeProperties(ComputingLinkedMap comparison, ConfigurationItem ci, Descriptor descriptor, int nrCi) {
        Collection nonHiddenDescriptors = Collections2.filter((Collection)descriptor.getPropertyDescriptors(), (Predicate)new Predicate<PropertyDescriptor>(){

            public boolean apply(PropertyDescriptor input) {
                return !input.isHidden();
            }
        });
        block5: for (PropertyDescriptor propertyDescriptor : nonHiddenDescriptors) {
            String key = propertyDescriptor.getName();
            Object value = propertyDescriptor.get(ci);
            if (propertyDescriptor.isPassword()) {
                value = PASSWORD_OBFUSCATION;
            }
            switch (propertyDescriptor.getKind()) {
                case BOOLEAN: 
                case INTEGER: 
                case STRING: 
                case ENUM: 
                case CI: {
                    comparison.put(key, value != null ? value.toString() : null, nrCi);
                    continue block5;
                }
                case SET_OF_STRING: 
                case SET_OF_CI: {
                    this.handleSetOfString(comparison, key, (Collection)value, nrCi);
                    continue block5;
                }
                case MAP_STRING_STRING: {
                    this.handleMap(comparison, key, (Map)value, nrCi);
                    continue block5;
                }
            }
            throw new IllegalStateException("Should not end up here!");
        }
    }

    private void handleMap(ComputingLinkedMap comparison, String key, Map<String, String> value, int nrCi) {
        if (value != null) {
            TreeSet<String> set = new TreeSet<String>(value.keySet());
            for (String k : set) {
                comparison.put(key + ": " + k, value.get(k), nrCi);
            }
        }
    }

    private void handleSetOfString(ComputingLinkedMap comparison, String key, Collection<String> value, int nrCi) {
        if (value != null) {
            ArrayList<String> list = new ArrayList<String>(value);
            Collections.sort(list);
            comparison.put(key, Joiner.on((String)",").join(list), nrCi);
        }
    }

    private void writeFields(ComputingLinkedMap comparison, ConfigurationItem entity, int nrCi) {
        comparison.put("id", entity.getId(), nrCi);
        comparison.put("type", entity.getType().toString(), nrCi);
    }

    private void checkCiTypes(Type referenceType, List<ConfigurationItem> entities) {
        for (ConfigurationItem entity : entities) {
            Checks.checkArgument(entity.getType().equals((Object)referenceType), "Not all configuration items are of type %s", referenceType);
        }
    }

    static class ComputingLinkedMap
    extends LinkedHashMap<String, List<String>> {
        private String[] strings;

        public ComputingLinkedMap(int listSize) {
            this.strings = new String[listSize];
            Arrays.fill(this.strings, "");
        }

        @Override
        public List<String> get(Object o) {
            List value = (List)super.get(o);
            if (value == null) {
                value = Lists.newArrayList((Object[])this.strings);
                super.put((String)o, value);
            }
            return value;
        }

        public void put(String key, String value, int position) {
            Object values = this.get(key);
            values.remove(position);
            values.add(position, value);
        }
    }
}

