/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.gc;

import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.data.GarbageCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GarbageCollectionStep
implements Step<ExecutionContext> {
    private Repository repository;
    private AtomicBoolean gcInProgress;
    private static final Logger logger = LoggerFactory.getLogger(GarbageCollectionStep.class);

    public GarbageCollectionStep(Repository repository, AtomicBoolean gcInProgress) {
        this.repository = repository;
        this.gcInProgress = gcInProgress;
    }

    public String getDescription() {
        return "Running garbage collection on the repository";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Step.Result execute(ExecutionContext ctx) throws Exception {
        logger.info("Running garbage collector to compact the DataStore");
        this.gcInProgress.set(true);
        try {
            Session garbageCollectionSession = this.repository.login((Credentials)new SimpleCredentials("anonymous", "".toCharArray()));
            try {
                GarbageCollector gc = ((RepositoryImpl)this.repository).createDataStoreGarbageCollector();
                try {
                    gc.mark();
                    gc.sweep();
                }
                finally {
                    gc.close();
                }
            }
            finally {
                garbageCollectionSession.logout();
            }
            logger.info("Garbage collector completed");
        }
        catch (RepositoryException exc) {
            logger.error("Cannot run the gargage collector", (Throwable)exc);
        }
        return Step.Result.Success;
    }
}

