/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer.reader;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.server.api.importer.ImportingContext;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.importer.ImporterException;
import com.xebialabs.overthere.local.LocalFile;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.fs.FsSyncException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployableConfigurationItemReader {
    static final String NAMESPACE_SEPARATOR = "/";
    static final String CI = "CI-";
    static final String TYPE_ATTRIBUTE_NAME = "CI-Type";
    static final String NAME_ATTRIBUTE_NAME = "CI-Name";
    private final Map<String, Attributes> entries;
    private static final Logger logger = LoggerFactory.getLogger(DeployableConfigurationItemReader.class);

    public DeployableConfigurationItemReader(Map<String, Attributes> entries) {
        this.entries = entries;
    }

    public Deployable readMiddlewareConfiguration(DeploymentPackage deploymentPackage, Map.Entry<String, Attributes> entry) {
        String entryName = entry.getKey().trim();
        Attributes entryAttributes = entry.getValue();
        String configurationItemType = this.readCIType(entryAttributes, entryName);
        Descriptor descriptor = this.getDescriptorForConfigurationItem(entryName, configurationItemType);
        Deployable configurationItem = (Deployable)descriptor.newInstance();
        String baseId = deploymentPackage.getId();
        configurationItem.setId(baseId + NAMESPACE_SEPARATOR + this.getDeployableNameFromEntryName(entryName));
        this.fillAttributes(configurationItem, descriptor, entryAttributes, baseId);
        return configurationItem;
    }

    public boolean isMiddlewareResource(Map.Entry<String, Attributes> entry) {
        String configurationItemType = entry.getValue().getValue(TYPE_ATTRIBUTE_NAME);
        String entryName = entry.getKey().trim();
        if (DeployableConfigurationItemReader.isBlank(configurationItemType)) {
            return false;
        }
        Descriptor configurationItemDescriptor = this.getDescriptorForConfigurationItem(entryName, configurationItemType);
        Checks.checkArgument(configurationItemDescriptor.isAssignableTo(Deployable.class), "Configuration item %s of type %s is not Deployable", entryName, configurationItemType);
        return !configurationItemDescriptor.isAssignableTo(DeployableArtifact.class);
    }

    public DeployableArtifact readArtifact(DeploymentPackage deploymentPackage, ImportSource source, Map.Entry<String, Attributes> entry, ImportingContext ctx) {
        String entryName = entry.getKey().trim();
        Attributes entryAttributes = entry.getValue();
        String configurationItemType = this.readCIType(entryAttributes, entryName);
        Descriptor descriptor = this.getDescriptorForConfigurationItem(entryName, configurationItemType);
        DeployableArtifact artifact = (DeployableArtifact)descriptor.newInstance();
        String baseId = deploymentPackage.getId();
        artifact.setId(baseId + NAMESPACE_SEPARATOR + this.getDeployableName(entryName, entryAttributes));
        TFile sourceArchive = new TFile(source.getFile());
        TFile tempFolder = this.createTempFolderForImport(ctx, (Artifact)artifact);
        TFile artifactFile = new TFile((File)sourceArchive, entryName, TArchiveDetector.NULL);
        TFile dest = new TFile((File)tempFolder, artifactFile.getName());
        try {
            artifactFile.cp_r((File)dest);
            if (sourceArchive.isArchive()) {
                TFile.umount((TFile)sourceArchive);
            }
        }
        catch (FsSyncException e) {
            logger.error("Unable to release resources for archive {}", (Object)sourceArchive.getName());
            logger.error("Following exception occurred while trying to release resources: {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeIOException(String.format("Could not copy %s to %s while importing %s", artifactFile, dest, artifact.getId()), e);
        }
        logger.debug("Adding {} {} to deployment package", (Object)descriptor.getType(), (Object)dest);
        artifact.setFile(LocalFile.valueOf((File)dest.getFile()));
        this.fillAttributes((Deployable)artifact, descriptor, entryAttributes, baseId);
        return artifact;
    }

    private TFile createTempFolderForImport(ImportingContext ctx, Artifact artifact) {
        try {
            String name = "temp-" + artifact.getName();
            TFile tempFolder = new TFile(File.createTempFile(name, "")).rm().mkdir(false);
            ((List)ctx.getAttribute("temporaryFiles")).add(tempFolder);
            logger.debug("Created Temporary folder {}", (Object)tempFolder);
            return tempFolder;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private String getDeployableName(String entryName, Attributes entryAttributes) {
        String name = entryAttributes.getValue(NAME_ATTRIBUTE_NAME);
        if (name != null) {
            return name;
        }
        return this.getDeployableNameFromEntryName(entryName);
    }

    protected String getDeployableNameFromEntryName(String entryName) {
        String name;
        int index = entryName.lastIndexOf(NAMESPACE_SEPARATOR);
        if (index > -1) {
            if (++index >= entryName.length()) {
                throw new ImporterException("Could not determine artifact Name: %s because entry ends with '/'", entryName);
            }
            name = entryName.substring(index);
        } else {
            name = entryName;
        }
        return name;
    }

    private String readCIType(Attributes entryAttributes, String entryName) {
        String configurationItemTypeShortName = entryAttributes.getValue(TYPE_ATTRIBUTE_NAME);
        if (DeployableConfigurationItemReader.isBlank(configurationItemTypeShortName)) {
            throw new ImporterException("Could not import Name: %s because of missing %s entry in MANIFEST.MF", entryName, TYPE_ATTRIBUTE_NAME);
        }
        return configurationItemTypeShortName;
    }

    private Descriptor getDescriptorForConfigurationItem(String entryName, String configurationItemTypeShortName) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((String)configurationItemTypeShortName);
        if (descriptor == null) {
            throw new ImporterException("Could not import Name: %s because %s is not a known CI type", entryName, configurationItemTypeShortName);
        }
        return descriptor;
    }

    private static boolean isBlank(String packageFormatVersion) {
        return Strings.nullToEmpty((String)packageFormatVersion).trim().isEmpty();
    }

    void fillAttributes(Deployable entity, Descriptor configurationItemDescriptor, Attributes entryAttributes, final String baseId) {
        block7: for (PropertyDescriptor propertyDescriptor : configurationItemDescriptor.getPropertyDescriptors()) {
            String name = propertyDescriptor.getName();
            switch (propertyDescriptor.getKind()) {
                case BOOLEAN: 
                case INTEGER: 
                case STRING: 
                case ENUM: {
                    String value = entryAttributes.getValue(CI + name);
                    propertyDescriptor.set((ConfigurationItem)entity, (Object)value);
                    continue block7;
                }
                case CI: {
                    String mfName = entryAttributes.getValue(CI + name);
                    if (mfName == null) continue block7;
                    Deployable configurationItem = this.convertReference(baseId, mfName, this.entries);
                    propertyDescriptor.set((ConfigurationItem)entity, (Object)configurationItem);
                    continue block7;
                }
                case SET_OF_STRING: {
                    Set<String> strings = DeployableConfigurationItemReader.handleSetOfStrings(propertyDescriptor, entryAttributes);
                    if (strings.isEmpty()) continue block7;
                    propertyDescriptor.set((ConfigurationItem)entity, strings);
                    continue block7;
                }
                case SET_OF_CI: {
                    HashSet cis = new HashSet(Collections2.transform(DeployableConfigurationItemReader.handleSetOfStrings(propertyDescriptor, entryAttributes), (Function)new Function<String, Deployable>(){

                        public Deployable apply(String from) {
                            return DeployableConfigurationItemReader.this.convertReference(baseId, from, DeployableConfigurationItemReader.this.entries);
                        }
                    }));
                    if (cis.isEmpty()) continue block7;
                    propertyDescriptor.set((ConfigurationItem)entity, cis);
                    continue block7;
                }
                case MAP_STRING_STRING: {
                    HashMap map = Maps.newHashMap();
                    String keyStart = (CI + propertyDescriptor.getName() + "-").toLowerCase();
                    for (Object attributeKey : entryAttributes.keySet()) {
                        String s = attributeKey.toString();
                        if (!s.toLowerCase().startsWith(keyStart)) continue;
                        String mapKey = s.substring(keyStart.length());
                        String mapValue = entryAttributes.getValue(s);
                        map.put(mapKey, mapValue);
                    }
                    propertyDescriptor.set((ConfigurationItem)entity, (Object)map);
                    continue block7;
                }
            }
            throw new IllegalStateException("Should not end up here!");
        }
    }

    private Deployable convertReference(String baseId, String mfName, Map<String, Attributes> entries) {
        Attributes referencedAttrs = Checks.checkNotNull(entries.get(mfName), "Couldn't find the referenced entry [%s], are you using the manifest Name?", mfName);
        Type ciType = Type.valueOf((String)this.readCIType(referencedAttrs, mfName));
        Descriptor ciDesc = DescriptorRegistry.getDescriptor((Type)ciType);
        Deployable configurationItem = (Deployable)ciDesc.newInstance();
        String ciName = referencedAttrs.getValue(NAME_ATTRIBUTE_NAME);
        if (ciName == null) {
            ciName = mfName;
        }
        configurationItem.setId(IdGenerator.generateId((String)baseId, (String)ciName));
        return configurationItem;
    }

    private static Set<String> handleSetOfStrings(PropertyDescriptor propertyDescriptor, Attributes entryAttributes) {
        String oldStyle = (CI + propertyDescriptor.getName() + "-EntryValue").toLowerCase();
        String key = (CI + propertyDescriptor.getName()).toLowerCase();
        HashSet strings = Sets.newHashSet();
        for (Map.Entry<Object, Object> entry : entryAttributes.entrySet()) {
            String entryKey = entry.getKey().toString().toLowerCase().trim();
            if (!entryKey.startsWith(oldStyle) && !entryKey.equals(key)) continue;
            strings.add(entry.getValue().toString());
        }
        return strings;
    }
}

