/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDescriptorDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemMethodDescriptorDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemPropertyDescriptorDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemPropertyKind;
import com.xebialabs.deployit.core.api.dto.FullTaskInfo;
import com.xebialabs.deployit.core.api.dto.StepInfo;
import com.xebialabs.deployit.core.api.dto.Steps;
import com.xebialabs.deployit.core.api.dto.TaskInfo;
import com.xebialabs.deployit.core.api.dto.TaskInfos;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.task.DeploymentTask;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.TaskStepInfo;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class DtoWriter {
    public ConfigurationItemDescriptorDto descriptorToDto(Descriptor descriptor) {
        Checks.checkNotNull((Object)descriptor, (String)"descriptor");
        ConfigurationItemDescriptorDto dto = new ConfigurationItemDescriptorDto();
        dto.setType(descriptor.getType().toString());
        dto.setSimpleName(descriptor.getType().toString());
        Function<Type, String> typeToString = new Function<Type, String>(){

            public String apply(Type from) {
                return from.toString();
            }
        };
        dto.setInterfaces((Set)Sets.newHashSet((Iterable)Collections2.transform((Collection)descriptor.getInterfaces(), (Function)typeToString)));
        dto.setSuperClasses((List)Lists.newArrayList((Iterable)Collections2.transform((Collection)descriptor.getSuperClasses(), (Function)typeToString)));
        Type deployableType = descriptor.getDeployableType();
        dto.setMappingSourceType(deployableType != null ? deployableType.toString() : "");
        Type containerType = descriptor.getContainerType();
        dto.setMappingTargetType(containerType != null ? containerType.toString() : "");
        dto.setDescription(descriptor.getDescription());
        dto.setPlaceholderFormatName("");
        dto.setPlaceholdersName("");
        dto.setRootName(descriptor.getRoot().getRootNodeName());
        for (PropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
            if (propertyDescriptor.isHidden()) continue;
            dto.addPropertyDescriptor(this.propertyDescriptorToDto(propertyDescriptor));
        }
        for (MethodDescriptor controlTask : descriptor.getControlTasks()) {
            dto.addControlTask(this.methodDescriptorToDto(controlTask));
        }
        return dto;
    }

    private ConfigurationItemMethodDescriptorDto methodDescriptorToDto(MethodDescriptor controlTask) {
        ConfigurationItemMethodDescriptorDto configurationItemMethodDescriptorDto = new ConfigurationItemMethodDescriptorDto();
        configurationItemMethodDescriptorDto.setDescription(controlTask.getDescription());
        configurationItemMethodDescriptorDto.setName(controlTask.getName());
        return configurationItemMethodDescriptorDto;
    }

    public ConfigurationItemPropertyDescriptorDto propertyDescriptorToDto(PropertyDescriptor propertyDescriptor) {
        Type referencedType;
        Checks.checkNotNull((Object)propertyDescriptor, (String)"propertydescriptor");
        ConfigurationItemPropertyDescriptorDto dto = new ConfigurationItemPropertyDescriptorDto();
        dto.setName(propertyDescriptor.getName());
        dto.setLabel(propertyDescriptor.getLabel());
        dto.setType(ConfigurationItemPropertyKind.valueOf((String)propertyDescriptor.getKind().toString()));
        if (propertyDescriptor.getEnumValues() != null) {
            dto.setEnumValues(propertyDescriptor.getEnumValues().toArray(new String[propertyDescriptor.getEnumValues().size()]));
        }
        dto.setCollectionMemberClassname((referencedType = propertyDescriptor.getReferencedType()) != null ? referencedType.toString() : "");
        dto.setPropertyClassname("");
        dto.setRequired(propertyDescriptor.isRequired());
        dto.setEditable(true);
        dto.setPassword(propertyDescriptor.isPassword());
        dto.setIdentifying(false);
        dto.setDiscoveryParam(false);
        dto.setDiscoveryRequired(false);
        dto.setCategory(propertyDescriptor.getCategory());
        dto.setSize(propertyDescriptor.getSize().toString());
        Object defaultValue = propertyDescriptor.getDefaultValue();
        dto.setDefaultValue(defaultValue == null ? null : defaultValue.toString());
        dto.setDescription(propertyDescriptor.getDescription());
        dto.setAsContainment(propertyDescriptor.isAsContainment());
        return dto;
    }

    public TaskInfos tasksToDto(List<Task> tasks) {
        TaskInfos taskInfos = new TaskInfos();
        for (Task eachTask : tasks) {
            taskInfos.add(this.taskToDto(eachTask.getId(), eachTask));
        }
        return taskInfos;
    }

    public TaskInfo taskToDto(String id, Task task) {
        Checks.checkNotNull((Object)id, (String)"id");
        Checks.checkNotNull((Object)task, (String)"task");
        TaskInfo ti = new TaskInfo();
        ti.setId(id);
        ti.setLabel(task.getLabel());
        ti.setState(task.getState().name());
        ti.setStartDate(task.getStartDate());
        ti.setCompletionDate(task.getCompletionDate());
        ti.setNrOfSteps(task.getNrOfSteps());
        ti.setCurrentStepNr(task.getCurrentStepNr());
        ti.setUser(task.getOwner());
        if (task instanceof DeploymentTask) {
            DeploymentTask dt = (DeploymentTask)task;
            ti.setApplication(dt.getApplicationName());
            ti.setVersion(dt.getApplicationVersion());
            ti.setEnvironment(dt.getEnvironment());
            ti.setFailureCount(dt.getFailureCount());
        }
        return ti;
    }

    public StepInfo taskStepInfoToDto(int stepNr, TaskStepInfo step) {
        Checks.checkNotNull((Object)step, (String)"step");
        StepInfo si = new StepInfo();
        si.setNr(stepNr);
        si.setDescription(step.getDescription());
        si.setState(step.getState().name());
        si.setStartDate(step.getStartDate());
        si.setCompletionDate(step.getCompletionDate());
        si.setLog(step.getLog());
        return si;
    }

    public Steps taskToDto(Task task) {
        return this.taskStepInfosToDto(task.getSteps());
    }

    public Steps taskStepInfosToDto(List<? extends TaskStepInfo> stepList) {
        Steps steps = new Steps();
        int stepNr = 1;
        for (TaskStepInfo taskStepInfo : stepList) {
            steps.add(this.taskStepInfoToDto(stepNr++, taskStepInfo));
        }
        return steps;
    }

    public TaskInfo archivedTaskToDto(DeploymentTaskInfo deploymentTask) {
        Checks.checkNotNull((Object)deploymentTask, (String)"deploymentTask");
        return this.populateTaskInfo(deploymentTask, new TaskInfo());
    }

    private <T extends TaskInfo> T populateTaskInfo(DeploymentTaskInfo deploymentTask, T taskInfo) {
        Checks.checkNotNull((Object)deploymentTask, (String)"deploymentTask");
        Checks.checkNotNull(taskInfo, (String)"taskInfo");
        taskInfo.setId(deploymentTask.getId());
        taskInfo.setLabel(String.format("Deployment of package:%s version:%s to env:%s", deploymentTask.getApplicationName(), deploymentTask.getApplicationVersion(), deploymentTask.getEnvironment()));
        taskInfo.setState(deploymentTask.getState().name());
        taskInfo.setStartDate(deploymentTask.getStartDate());
        taskInfo.setCompletionDate(deploymentTask.getCompletionDate());
        taskInfo.setNrOfSteps(deploymentTask.getSteps().size());
        taskInfo.setCurrentStepNr(deploymentTask.getCurrentStepNr());
        taskInfo.setUser(deploymentTask.getOwner());
        taskInfo.setEnvironment(deploymentTask.getEnvironment());
        taskInfo.setApplication(deploymentTask.getApplicationName());
        taskInfo.setVersion(deploymentTask.getApplicationVersion());
        return taskInfo;
    }

    public FullTaskInfo fullArchivedTaskToDto(DeploymentTaskInfo deploymentTaskInfo) {
        Checks.checkNotNull((Object)deploymentTaskInfo, (String)"deploymentTaskInfo");
        int stepNr = 1;
        FullTaskInfo fullTaskInfo = this.populateTaskInfo(deploymentTaskInfo, new FullTaskInfo());
        for (TaskStepInfo taskStepInfo : deploymentTaskInfo.getSteps()) {
            fullTaskInfo.addStep(this.taskStepInfoToDto(stepNr++, taskStepInfo));
        }
        return fullTaskInfo;
    }
}

