/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Function;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.core.api.QueryProxy;
import com.xebialabs.deployit.core.api.dto.Comparison;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDtos;
import com.xebialabs.deployit.core.api.dto.PropertyValue;
import com.xebialabs.deployit.core.api.dto.RepositoryObjectIds;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.api.ConfigurationItemDtoWriter;
import com.xebialabs.deployit.core.rest.api.SearchParameterFactory;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.service.comparison.Comparator;
import java.util.List;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class QueryResource
implements QueryProxy {
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ConfigurationItemDtoWriter dtoWriter;
    @Autowired
    private Comparator comparator;
    private static final Logger logger = LoggerFactory.getLogger(QueryResource.class);

    public Response list(@QueryParam(value="typeName") String typeName, @QueryParam(value="archetype") boolean archetype, @QueryParam(value="page") long page, @QueryParam(value="resultsPerPage") long resultPerPage, @QueryParam(value="property") List<PropertyValue> values, String parent, String id) {
        SearchParameters searchParam = SearchParameterFactory.createSearchParam(typeName, page, resultPerPage, values, parent, id);
        RepositoryObjectIds dto = new RepositoryObjectIds();
        dto.setRepositoryEntityIds(this.repositoryService.list(searchParam));
        return ResponseFactory.ok((Object)dto).build();
    }

    public Response readMultiple(RepositoryObjectIds repositoryObjectIds) {
        ConfigurationItemDtos result = new ConfigurationItemDtos();
        for (String repositoryObjectId : repositoryObjectIds.getRepositoryEntityIds()) {
            ConfigurationItem entity = this.repositoryService.read(repositoryObjectId);
            result.add(this.dtoWriter.write(entity));
        }
        return ResponseFactory.ok((Object)result).build();
    }

    public Response compare(String reference, List<String> ids) {
        ConfigurationItem referenceEntity = this.repositoryService.read(reference);
        ListMultimap multimap = this.comparator.compare(referenceEntity, Lists.transform(ids, (Function)new Function<String, ConfigurationItem>(){

            public ConfigurationItem apply(String input) {
                return QueryResource.this.repositoryService.read(input);
            }
        }));
        return ResponseFactory.ok((Object)Comparison.from((ListMultimap)multimap)).build();
    }

    public Response search(@QueryParam(value="typeName") String typeName, @QueryParam(value="before") Date date) {
        logger.info("Searching for all [{}] with last modified before [{}]", (Object)typeName, (Object)date);
        SearchParameters searchParam = SearchParameterFactory.createSearchParam(typeName, 0L, -1L, Lists.newArrayList());
        searchParam.setBefore(date.getCalendar());
        List ids = this.repositoryService.list(searchParam);
        logger.debug("Found ids: {}", (Object)ids);
        return ResponseFactory.ok((Object)new RepositoryObjectIds(ids)).build();
    }
}

