/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import java.awt.geom.AffineTransform;

public class Matrix
implements Cloneable {
    private float[] single = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};

    public AffineTransform createAffineTransform() {
        AffineTransform retval = new AffineTransform(this.single[0], this.single[1], this.single[3], this.single[4], this.single[6], this.single[7]);
        return retval;
    }

    public void setFromAffineTransform(AffineTransform af) {
        this.single[0] = (float)af.getScaleX();
        this.single[1] = (float)af.getShearY();
        this.single[3] = (float)af.getShearX();
        this.single[4] = (float)af.getScaleY();
        this.single[6] = (float)af.getTranslateX();
        this.single[7] = (float)af.getTranslateY();
    }

    public float getValue(int row, int column) {
        return this.single[row * 3 + column];
    }

    public void setValue(int row, int column, float value) {
        this.single[row * 3 + column] = value;
    }

    public float[][] getValues() {
        float[][] retval = new float[3][3];
        retval[0][0] = this.single[0];
        retval[0][1] = this.single[1];
        retval[0][2] = this.single[2];
        retval[1][0] = this.single[3];
        retval[1][1] = this.single[4];
        retval[1][2] = this.single[5];
        retval[2][0] = this.single[6];
        retval[2][1] = this.single[7];
        retval[2][2] = this.single[8];
        return retval;
    }

    public double[][] getValuesAsDouble() {
        double[][] retval = new double[3][3];
        retval[0][0] = this.single[0];
        retval[0][1] = this.single[1];
        retval[0][2] = this.single[2];
        retval[1][0] = this.single[3];
        retval[1][1] = this.single[4];
        retval[1][2] = this.single[5];
        retval[2][0] = this.single[6];
        retval[2][1] = this.single[7];
        retval[2][2] = this.single[8];
        return retval;
    }

    public Matrix multiply(Matrix b) {
        Matrix result = new Matrix();
        if (b != null && b.single != null) {
            float[] bMatrix = b.single;
            float[] resultMatrix = result.single;
            resultMatrix[0] = this.single[0] * bMatrix[0] + this.single[1] * bMatrix[3] + this.single[2] * bMatrix[6];
            resultMatrix[1] = this.single[0] * bMatrix[1] + this.single[1] * bMatrix[4] + this.single[2] * bMatrix[7];
            resultMatrix[2] = this.single[0] * bMatrix[2] + this.single[1] * bMatrix[5] + this.single[2] * bMatrix[8];
            resultMatrix[3] = this.single[3] * bMatrix[0] + this.single[4] * bMatrix[3] + this.single[5] * bMatrix[6];
            resultMatrix[4] = this.single[3] * bMatrix[1] + this.single[4] * bMatrix[4] + this.single[5] * bMatrix[7];
            resultMatrix[5] = this.single[3] * bMatrix[2] + this.single[4] * bMatrix[5] + this.single[5] * bMatrix[8];
            resultMatrix[6] = this.single[6] * bMatrix[0] + this.single[7] * bMatrix[3] + this.single[8] * bMatrix[6];
            resultMatrix[7] = this.single[6] * bMatrix[1] + this.single[7] * bMatrix[4] + this.single[8] * bMatrix[7];
            resultMatrix[8] = this.single[6] * bMatrix[2] + this.single[7] * bMatrix[5] + this.single[8] * bMatrix[8];
        }
        return result;
    }

    public Matrix extractScaling() {
        Matrix retval = new Matrix();
        retval.single[0] = this.single[0];
        retval.single[4] = this.single[4];
        return retval;
    }

    public static Matrix getScaleInstance(float x, float y) {
        Matrix retval = new Matrix();
        retval.single[0] = x;
        retval.single[4] = y;
        return retval;
    }

    public Matrix extractTranslating() {
        Matrix retval = new Matrix();
        retval.single[6] = this.single[6];
        retval.single[7] = this.single[7];
        return retval;
    }

    public static Matrix getTranslatingInstance(float x, float y) {
        Matrix retval = new Matrix();
        retval.single[6] = x;
        retval.single[7] = y;
        return retval;
    }

    public Object clone() {
        Matrix clone = new Matrix();
        System.arraycopy(this.single, 0, clone.single, 0, 9);
        return clone;
    }

    public Matrix copy() {
        return (Matrix)this.clone();
    }

    public String toString() {
        StringBuffer result = new StringBuffer("");
        result.append("[[");
        result.append(this.single[0] + ",");
        result.append(this.single[1] + ",");
        result.append(this.single[2] + "][");
        result.append(this.single[3] + ",");
        result.append(this.single[4] + ",");
        result.append(this.single[5] + "][");
        result.append(this.single[6] + ",");
        result.append(this.single[7] + ",");
        result.append(this.single[8] + "]]");
        return result.toString();
    }

    public float getXScale() {
        float xScale = this.single[0];
        if (this.single[1] != 0.0f || this.single[3] != 0.0f) {
            xScale = (float)Math.sqrt(Math.pow(this.single[0], 2.0) + Math.pow(this.single[1], 2.0));
        }
        return xScale;
    }

    public float getYScale() {
        float yScale = this.single[4];
        if (this.single[1] != 0.0f || this.single[3] != 0.0f) {
            yScale = (float)Math.sqrt(Math.pow(this.single[3], 2.0) + Math.pow(this.single[4], 2.0));
        }
        return yScale;
    }

    public float getXPosition() {
        return this.single[6];
    }

    public float getYPosition() {
        return this.single[7];
    }
}

