/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs.winrm;

import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.cifs.winrm.Action;
import com.xebialabs.overthere.cifs.winrm.HttpConnector;
import com.xebialabs.overthere.cifs.winrm.Namespaces;
import com.xebialabs.overthere.cifs.winrm.OptionSet;
import com.xebialabs.overthere.cifs.winrm.ResourceURI;
import com.xebialabs.overthere.cifs.winrm.ResponseExtractor;
import com.xebialabs.overthere.cifs.winrm.SoapAction;
import com.xebialabs.overthere.cifs.winrm.exception.WinRMRuntimeIOException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.List;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WinRmClient {
    private final URL targetURL;
    private final HttpConnector connector;
    private String timeout;
    private int envelopSize;
    private String locale;
    private String exitCode;
    private String shellId;
    private String commandId;
    private int chunk = 0;
    private static Logger logger = LoggerFactory.getLogger(WinRmClient.class);

    public WinRmClient(HttpConnector connector, URL targetURL) {
        this.connector = connector;
        this.targetURL = targetURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runCmd(String command, OverthereProcessOutputHandler handler) {
        try {
            this.shellId = this.openShell();
            this.commandId = this.runCommand(command);
            this.getCommandOutput(handler);
        }
        finally {
            this.cleanUp();
            this.closeShell();
        }
    }

    private void closeShell() {
        if (this.shellId == null) {
            return;
        }
        logger.debug("closeShell shellId {}", (Object)this.shellId);
        Document requestDocument = this.getRequestDocument(Action.WS_DELETE, ResourceURI.RESOURCE_URI_CMD, null, this.shellId, null);
        this.sendMessage(requestDocument, null);
    }

    private void cleanUp() {
        if (this.commandId == null) {
            return;
        }
        logger.debug("cleanUp shellId {} commandId {} ", (Object)this.shellId, (Object)this.commandId);
        Element bodyContent = DocumentHelper.createElement((QName)QName.get((String)"Signal", (Namespace)Namespaces.NS_WIN_SHELL)).addAttribute("CommandId", this.commandId);
        bodyContent.addElement(QName.get((String)"Code", (Namespace)Namespaces.NS_WIN_SHELL)).addText("http://schemas.microsoft.com/wbem/wsman/1/windows/shell/signal/terminate");
        Document requestDocument = this.getRequestDocument(Action.WS_SIGNAL, ResourceURI.RESOURCE_URI_CMD, null, this.shellId, bodyContent);
        this.sendMessage(requestDocument, SoapAction.SIGNAL);
    }

    private void getCommandOutput(OverthereProcessOutputHandler handler) {
        Document responseDocument;
        List list;
        logger.debug("getCommandOutput shellId {} commandId {} ", (Object)this.shellId, (Object)this.commandId);
        Element bodyContent = DocumentHelper.createElement((QName)QName.get((String)"Receive", (Namespace)Namespaces.NS_WIN_SHELL));
        bodyContent.addElement(QName.get((String)"DesiredStream", (Namespace)Namespaces.NS_WIN_SHELL)).addAttribute("CommandId", this.commandId).addText("stdout stderr");
        Document requestDocument = this.getRequestDocument(Action.WS_RECEIVE, ResourceURI.RESOURCE_URI_CMD, null, this.shellId, bodyContent);
        do {
            responseDocument = this.sendMessage(requestDocument, SoapAction.RECEIVE);
            String stdout = this.handleStream(responseDocument, ResponseExtractor.STDOUT);
            BufferedReader stdoutReader = new BufferedReader(new StringReader(stdout));
            try {
                String line;
                while ((line = stdoutReader.readLine()) != null) {
                    handler.handleOutputLine(line);
                }
            }
            catch (IOException exc) {
                throw new RuntimeIOException("Unexpected I/O exception while reading stdout", exc);
            }
            String stderr = this.handleStream(responseDocument, ResponseExtractor.STDERR);
            BufferedReader stderrReader = new BufferedReader(new StringReader(stderr));
            try {
                String line;
                while ((line = stderrReader.readLine()) != null) {
                    handler.handleErrorLine(line);
                }
            }
            catch (IOException exc) {
                throw new RuntimeIOException("Unexpected I/O exception while reading stderr", exc);
            }
            if (this.chunk == 0) {
                try {
                    this.exitCode = this.getFirstElement(responseDocument, ResponseExtractor.EXIT_CODE);
                    logger.info("exit code {}", (Object)this.exitCode);
                }
                catch (Exception e) {
                    logger.debug("not found");
                }
            }
            ++this.chunk;
        } while ((list = ResponseExtractor.STREAM_DONE.getXPath().selectNodes((Object)responseDocument)).isEmpty());
        this.exitCode = this.getFirstElement(responseDocument, ResponseExtractor.EXIT_CODE);
        logger.info("exit code {}", (Object)this.exitCode);
        logger.debug("all the command output has been fetched (chunk={})", (Object)this.chunk);
    }

    private String handleStream(Document responseDocument, ResponseExtractor stream) {
        StringBuffer buffer = new StringBuffer();
        List streams = stream.getXPath().selectNodes((Object)responseDocument);
        if (!streams.isEmpty()) {
            Base64 base64 = new Base64();
            for (Element e : streams) {
                byte[] decode = base64.decode(e.getText());
                buffer.append(new String(decode));
            }
        }
        logger.debug("handleStream {} buffer {}", (Object)stream, (Object)buffer);
        return buffer.toString();
    }

    private String runCommand(String command) {
        logger.debug("runCommand shellId {} command {}", (Object)this.shellId, (Object)command);
        Element bodyContent = DocumentHelper.createElement((QName)QName.get((String)"CommandLine", (Namespace)Namespaces.NS_WIN_SHELL));
        String encoded = command;
        encoded = "\"" + encoded + "\"";
        logger.info("Encoded command is {}", (Object)encoded);
        bodyContent.addElement(QName.get((String)"Command", (Namespace)Namespaces.NS_WIN_SHELL)).addText(encoded);
        Document requestDocument = this.getRequestDocument(Action.WS_COMMAND, ResourceURI.RESOURCE_URI_CMD, OptionSet.RUN_COMMAND, this.shellId, bodyContent);
        Document responseDocument = this.sendMessage(requestDocument, SoapAction.COMMAND_LINE);
        return this.getFirstElement(responseDocument, ResponseExtractor.COMMAND_ID);
    }

    private String getFirstElement(Document doc, ResponseExtractor extractor) {
        List nodes = extractor.getXPath().selectNodes((Object)doc);
        if (nodes.isEmpty()) {
            throw new RuntimeException("Cannot find " + extractor.getXPath() + " in " + this.toString(doc));
        }
        Element next = (Element)nodes.iterator().next();
        return next.getText();
    }

    private String openShell() {
        logger.debug("openShell");
        Element bodyContent = DocumentHelper.createElement((QName)QName.get((String)"Shell", (Namespace)Namespaces.NS_WIN_SHELL));
        bodyContent.addElement(QName.get((String)"InputStreams", (Namespace)Namespaces.NS_WIN_SHELL)).addText("stdin");
        bodyContent.addElement(QName.get((String)"OutputStreams", (Namespace)Namespaces.NS_WIN_SHELL)).addText("stdout stderr");
        Document requestDocument = this.getRequestDocument(Action.WS_ACTION, ResourceURI.RESOURCE_URI_CMD, OptionSet.OPEN_SHELL, null, bodyContent);
        Document responseDocument = this.sendMessage(requestDocument, SoapAction.SHELL);
        return this.getFirstElement(responseDocument, ResponseExtractor.SHELL_ID);
    }

    private Document sendMessage(Document requestDocument, SoapAction soapAction) {
        return this.connector.sendMessage(requestDocument, soapAction);
    }

    private Document getRequestDocument(Action action, ResourceURI resourceURI, OptionSet optionSet, String shelId, Element bodyContent) {
        Document doc = DocumentHelper.createDocument();
        Element envelope = doc.addElement(QName.get((String)"Envelope", (Namespace)Namespaces.NS_SOAP_ENV));
        envelope.add(this.getHeader(action, resourceURI, optionSet, shelId));
        Element body = envelope.addElement(QName.get((String)"Body", (Namespace)Namespaces.NS_SOAP_ENV));
        if (bodyContent != null) {
            body.add(bodyContent);
        }
        return doc;
    }

    private Element getHeader(Action action, ResourceURI resourceURI, OptionSet optionSet, String shellId) {
        Element header = DocumentHelper.createElement((QName)QName.get((String)"Header", (Namespace)Namespaces.NS_SOAP_ENV));
        header.addElement(QName.get((String)"To", (Namespace)Namespaces.NS_ADDRESSING)).addText(this.targetURL.toString());
        Element replyTo = header.addElement(QName.get((String)"ReplyTo", (Namespace)Namespaces.NS_ADDRESSING));
        replyTo.addElement(QName.get((String)"Address", (Namespace)Namespaces.NS_ADDRESSING)).addAttribute("mustUnderstand", "true").addText("http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous");
        header.addElement(QName.get((String)"MaxEnvelopeSize", (Namespace)Namespaces.NS_WSMAN_DMTF)).addAttribute("mustUnderstand", "true").addText("" + this.envelopSize);
        header.addElement(QName.get((String)"MessageID", (Namespace)Namespaces.NS_ADDRESSING)).addText(this.getUUID());
        header.addElement(QName.get((String)"Locale", (Namespace)Namespaces.NS_WSMAN_DMTF)).addAttribute("mustUnderstand", "false").addAttribute("xml:lang", this.locale);
        header.addElement(QName.get((String)"DataLocale", (Namespace)Namespaces.NS_WSMAN_MSFT)).addAttribute("mustUnderstand", "false").addAttribute("xml:lang", this.locale);
        header.addElement(QName.get((String)"OperationTimeout", (Namespace)Namespaces.NS_WSMAN_DMTF)).addText(this.timeout);
        header.add(action.getElement());
        if (shellId != null) {
            header.addElement(QName.get((String)"SelectorSet", (Namespace)Namespaces.NS_WSMAN_DMTF)).addElement(QName.get((String)"Selector", (Namespace)Namespaces.NS_WSMAN_DMTF)).addAttribute("Name", "ShellId").addText(shellId);
        }
        header.add(resourceURI.getElement());
        if (optionSet != null) {
            header.add(optionSet.getElement());
        }
        return header;
    }

    private String toString(Document doc) {
        StringWriter stringWriter = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, OutputFormat.createPrettyPrint());
        try {
            xmlWriter.write(doc);
            xmlWriter.close();
        }
        catch (IOException e) {
            throw new WinRMRuntimeIOException("error ", e);
        }
        return stringWriter.toString();
    }

    private String getUUID() {
        return "uuid:" + UUID.randomUUID().toString().toUpperCase();
    }

    public int getExitCode() {
        return Integer.parseInt(this.exitCode);
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public int getEnvelopSize() {
        return this.envelopSize;
    }

    public void setEnvelopSize(int envelopSize) {
        this.envelopSize = envelopSize;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public URL getTargetURL() {
        return this.targetURL;
    }
}

