/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SshInteractiveSudoPasswordHandlingStream
extends FilterInputStream {
    private final OutputStream remoteStdin;
    private final byte[] passwordBytes;
    private final String passwordRegex;
    private final Pattern passwordPattern;
    private final StringBuilder receivedOutputBuffer = new StringBuilder();
    private boolean onFirstLine = true;
    private static Logger logger = LoggerFactory.getLogger(SshInteractiveSudoPasswordHandlingStream.class);

    protected SshInteractiveSudoPasswordHandlingStream(InputStream remoteStdout, OutputStream remoteStdin, String password, String passwordPromptRegex) {
        super(remoteStdout);
        this.remoteStdin = remoteStdin;
        this.passwordBytes = (password + "\r\n").getBytes();
        this.passwordRegex = passwordPromptRegex;
        this.passwordPattern = Pattern.compile(this.passwordRegex);
    }

    @Override
    public int read() throws IOException {
        int readInt = super.read();
        if (readInt > -1) {
            this.handleChar((char)readInt);
        }
        return readInt;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int numBytesRead = super.read(b, off, len);
        if (numBytesRead > -1) {
            for (int i = 0; i < numBytesRead; ++i) {
                this.handleChar((char)b[off + i]);
            }
        }
        return numBytesRead;
    }

    private void handleChar(char c) {
        if (this.onFirstLine) {
            logger.trace("Received: {}", (Object)Character.valueOf(c));
            if (c == '\n') {
                this.onFirstLine = false;
            } else {
                String receivedOutput;
                this.receivedOutputBuffer.append(c);
                if (c == this.passwordRegex.charAt(this.passwordRegex.length() - 1) && this.passwordPattern.matcher(receivedOutput = this.receivedOutputBuffer.toString()).matches()) {
                    logger.info("Found password prompt in first line of output: {}", (Object)receivedOutput);
                    try {
                        this.remoteStdin.write(this.passwordBytes);
                        this.remoteStdin.flush();
                        logger.debug("Sent password");
                    }
                    catch (IOException exc) {
                        logger.error("Cannot send password", (Throwable)exc);
                    }
                }
            }
        }
    }
}

