/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.CmdLineArgument;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.ssh.SshScpConnection;
import com.xebialabs.overthere.ssh.SshSudoFile;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SshSudoConnection
extends SshScpConnection {
    public static final String SUDO_COMMAND = "sudo";
    public static final String NOSUDO_PSEUDO_COMMAND = "nosudo";
    protected String sudoUsername;
    protected String sudoCommandPrefix;
    protected boolean sudoQuoteCommand;
    protected boolean sudoOverrideUmask;
    private Logger logger = LoggerFactory.getLogger(SshSudoConnection.class);

    public SshSudoConnection(String type, ConnectionOptions options) {
        super(type, options);
        this.sudoUsername = (String)options.get("sudoUsername");
        this.sudoCommandPrefix = options.get("sudoCommandPrefix", "sudo -u {0}");
        this.sudoQuoteCommand = options.get("sudoQuoteCommand", false);
        this.sudoOverrideUmask = options.get("sudoOverrideUmask", false);
    }

    @Override
    protected CmdLine processCommandLine(CmdLine commandLine) {
        CmdLine cmd = commandLine.getArguments().size() >= 2 && commandLine.getArguments().get(0).toString(this.os, false).equals(NOSUDO_PSEUDO_COMMAND) ? this.stripNosudoCommand(commandLine) : this.prefixWithSudoCommand(commandLine);
        return super.processCommandLine(cmd);
    }

    protected CmdLine stripNosudoCommand(CmdLine commandLine) {
        return new CmdLine().add(commandLine.getArguments().subList(1, commandLine.getArguments().size()));
    }

    protected CmdLine prefixWithSudoCommand(CmdLine commandLine) {
        CmdLine commandLineWithSudo = new CmdLine();
        this.addSudoStatement(commandLineWithSudo);
        if (this.sudoQuoteCommand) {
            commandLineWithSudo.addNested(commandLine);
        } else {
            for (CmdLineArgument a : commandLine.getArguments()) {
                commandLineWithSudo.add(a);
                if (!a.toString(this.os, false).equals("|") && !a.toString(this.os, false).equals(";")) continue;
                this.addSudoStatement(commandLineWithSudo);
            }
        }
        return commandLineWithSudo;
    }

    protected void addSudoStatement(CmdLine sudoCommandLine) {
        String prefix = MessageFormat.format(this.sudoCommandPrefix, this.sudoUsername);
        for (String arg : prefix.split("\\s+")) {
            sudoCommandLine.addArgument(arg);
        }
    }

    protected int noSudoExecute(OverthereProcessOutputHandler handler, CmdLine commandLine) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("NOT adding sudo statement");
        }
        CmdLine nosudoCommandLine = new CmdLine();
        nosudoCommandLine.addArgument(NOSUDO_PSEUDO_COMMAND);
        nosudoCommandLine.add(commandLine.getArguments());
        return this.execute(handler, nosudoCommandLine);
    }

    @Override
    protected OverthereFile getFile(String hostPath, boolean isTempFile) throws RuntimeIOException {
        return new SshSudoFile(this, hostPath, isTempFile);
    }

    @Override
    public String toString() {
        return "ssh:" + this.sshConnectionType.toString().toLowerCase() + "://" + this.username + ":" + this.sudoUsername + "@" + this.host + ":" + this.port;
    }
}

