/*
 * Decompiled with CFR 0.152.
 */
package nl.javadude.scannit.registry;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import nl.javadude.scannit.metadata.DescriptorHelper;
import nl.javadude.scannit.registry.Registry;
import nl.javadude.scannit.scanner.AbstractScanner;
import nl.javadude.scannit.scanner.FieldAnnotationScanner;
import nl.javadude.scannit.scanner.MethodAnnotationScanner;
import nl.javadude.scannit.scanner.SubTypeScanner;
import nl.javadude.scannit.scanner.TypeAnnotationScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryHelper {
    private Registry registry;

    public RegistryHelper(Registry registry) {
        this.registry = registry;
    }

    public Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotation, boolean findInheritors) {
        HashSet strings = Sets.newHashSet((Iterable)this.registry.get(TypeAnnotationScanner.class).get((Object)annotation.getName()));
        if (findInheritors && annotation.isAnnotationPresent(Inherited.class)) {
            strings.addAll(this.findSubtypes(strings));
        }
        return this.convertToClassSet(strings);
    }

    private <T> ImmutableSet<Class<? extends T>> convertToClassSet(Set<String> strings) {
        return ImmutableSet.copyOf((Iterable)Iterables.transform(strings, (Function)new Function<String, Class<? extends T>>(){

            public Class<? extends T> apply(String input) {
                return DescriptorHelper.fromTypeDescriptor(input);
            }
        }));
    }

    public <T> Set<Class<? extends T>> getSubTypesOf(Class<T> clazz) {
        HashSet strings = Sets.newHashSet((Iterable)this.registry.get(SubTypeScanner.class).get((Object)clazz.getName()));
        strings.addAll(this.findSubtypes(strings));
        return this.convertToClassSet(strings);
    }

    private Collection<String> findSubtypes(Collection<String> superclazzes) {
        HashSet subclazzes = Sets.newHashSet();
        for (String superclazz : superclazzes) {
            Collection strings = this.registry.get(SubTypeScanner.class).get((Object)superclazz);
            if (strings.isEmpty()) continue;
            subclazzes.addAll(strings);
            subclazzes.addAll(this.findSubtypes(subclazzes));
        }
        return subclazzes;
    }

    public Set<Method> getMethodsAnnotatedWith(Class<? extends Annotation> annotation) {
        return this.getAnnotatedThings(annotation, MethodAnnotationScanner.class, new Function<String, Method>(){

            public Method apply(String input) {
                return DescriptorHelper.fromMethodDescriptor(input);
            }
        });
    }

    public Set<Field> getFieldsAnnotatedWith(Class<? extends Annotation> annotation) {
        return this.getAnnotatedThings(annotation, FieldAnnotationScanner.class, new Function<String, Field>(){

            public Field apply(String input) {
                return DescriptorHelper.fromFieldDescriptor(input);
            }
        });
    }

    private <T> Set<T> getAnnotatedThings(Class<? extends Annotation> annotation, Class<? extends AbstractScanner> clazz, Function<String, T> function) {
        Collection strings = this.registry.get(clazz).get((Object)annotation.getName());
        return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)strings, function));
    }
}

