/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.ci;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionPlanningContext;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.generic.ci.GenericContainer;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.deployit.plugin.generic.step.InspectScriptExecutionStep;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Metadata(virtual=true, description="A container to which generic CIs can be deployed. Start, stop and restart behavior of this container can be controlled using the corresponding script properties.")
public class Container
extends BaseContainer
implements GenericContainer {
    protected Map<String, Object> freeMarkerContext = Collections.singletonMap("container", this);
    @Property(asContainment=true, description="Host upon which the container resides")
    private Host host;
    @Property(required=false, hidden=true, description="Classpath to the script used to start the generic container.")
    private String startScript;
    @Property(required=false, hidden=true, description="Classpath to the script used to stop the generic container.")
    private String stopScript;
    @Property(required=false, hidden=true, description="Classpath to the script used to restart the generic container.")
    private String restartScript;
    @Property(defaultValue="90", hidden=true, description="The order of the start container step in the step list.")
    private int startOrder;
    @Property(defaultValue="10", hidden=true, description="The order of the stop container step in the step list.")
    private int stopOrder;
    @Property(defaultValue="90", hidden=true, description="The order of the restart container step in the step list.")
    private int restartOrder;
    @Property(required=false, defaultValue="0", hidden=true, description="The time to wait in seconds for a container restart action.")
    private int restartWaitTime;
    @Property(defaultValue="0", hidden=true, description="The time to wait in seconds for a container start action.")
    private int startWaitTime;
    @Property(defaultValue="0", hidden=true, description="The time to wait in seconds for a container stop action.")
    private int stopWaitTime;
    @Property(required=false, description="Environment variables for container", label="Environment Variables")
    private Map<String, String> envVars = Maps.newHashMap();
    @Property(required=false, hidden=true, description="Classpath to the script used to inspect the generic container.")
    private String inspectScript;
    @Property(hidden=true, required=false, description="Additional classpath resources that should be uploaded to the working directory before executing the inspect script.")
    private Set<String> inspectClasspathResources = Sets.newHashSet();
    @Property(hidden=true, required=false, description="Additional template classpath resources that should be uploaded to the working directory before executing the inspect script.The template is first rendered and the rendered content copied to a file, with the same name as the template, in the working directory.")
    private Set<String> inspectTemplateClasspathResources = Sets.newHashSet();

    public List<Step> controlTaskDispatch(String string) {
        String string2 = string + "Script";
        PropertyDescriptor propertyDescriptor = DescriptorRegistry.getDescriptor((Type)this.getType()).getPropertyDescriptor(string2);
        Preconditions.checkArgument((propertyDescriptor != null ? 1 : 0) != 0, (String)"Control task script property %s not defined for CI type %s", (Object[])new Object[]{string2, this.getType()});
        String string3 = ConfigurationHolder.resolveExpression((String)propertyDescriptor.get((ConfigurationItem)this), this.freeMarkerContext);
        return Collections.singletonList(new ScriptExecutionStep(1, string3, this, this.freeMarkerContext, "Executing " + string));
    }

    public Map<String, String> getEnvVars() {
        return ConfigurationHolder.resolveExpression(this.envVars, this.freeMarkerContext);
    }

    public void setEnvVars(Map<String, String> map) {
        this.envVars = map;
    }

    @Inspect
    public void inspectContainer(InspectionPlanningContext inspectionPlanningContext) {
        if (Strings.emptyToNull((String)this.getInspectScript()) != null) {
            InspectScriptExecutionStep inspectScriptExecutionStep = new InspectScriptExecutionStep((ConfigurationItem)this, this.getInspectScript(), (HostContainer)this.getHost(), this.freeMarkerContext, "Inspect " + this);
            inspectScriptExecutionStep.setTemplateClasspathResources(Lists.newArrayList(this.getInspectTemplateClasspathResources()));
            inspectScriptExecutionStep.setClasspathResources(Lists.newArrayList(this.getInspectClasspathResources()));
            inspectionPlanningContext.addStep((Step)inspectScriptExecutionStep);
        }
    }

    public Host getHost() {
        return this.host;
    }

    @Override
    public <T extends GenericContainer> T getParentContainer() {
        return null;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    public String getStartScript() {
        return ConfigurationHolder.resolveExpression(this.startScript, this.freeMarkerContext);
    }

    public void setStartScript(String string) {
        this.startScript = string;
    }

    public String getStopScript() {
        return ConfigurationHolder.resolveExpression(this.stopScript, this.freeMarkerContext);
    }

    public void setStopScript(String string) {
        this.stopScript = string;
    }

    public String getRestartScript() {
        return ConfigurationHolder.resolveExpression(this.restartScript, this.freeMarkerContext);
    }

    public void setRestartScript(String string) {
        this.restartScript = string;
    }

    public int getStartOrder() {
        return this.startOrder;
    }

    public void setStartOrder(int n) {
        this.startOrder = n;
    }

    public int getStopOrder() {
        return this.stopOrder;
    }

    public void setStopOrder(int n) {
        this.stopOrder = n;
    }

    public int getRestartOrder() {
        return this.restartOrder;
    }

    public void setRestartOrder(int n) {
        this.restartOrder = n;
    }

    public int getRestartWaitTime() {
        return this.restartWaitTime;
    }

    public void setRestartWaitTime(int n) {
        this.restartWaitTime = n;
    }

    public int getStartWaitTime() {
        return this.startWaitTime;
    }

    public void setStartWaitTime(int n) {
        this.startWaitTime = n;
    }

    public int getStopWaitTime() {
        return this.stopWaitTime;
    }

    public void setStopWaitTime(int n) {
        this.stopWaitTime = n;
    }

    public String getInspectScript() {
        return ConfigurationHolder.resolveExpression(this.inspectScript, this.freeMarkerContext);
    }

    public void setInspectScript(String string) {
        this.inspectScript = string;
    }

    public Set<String> getInspectClasspathResources() {
        return ConfigurationHolder.resolveExpression(this.inspectClasspathResources, this.freeMarkerContext);
    }

    public void setInspectClasspathResources(Set<String> set) {
        this.inspectClasspathResources = set;
    }

    public Set<String> getInspectTemplateClasspathResources() {
        return ConfigurationHolder.resolveExpression(this.inspectTemplateClasspathResources, this.freeMarkerContext);
    }

    public void setInspectTemplateClasspathResources(Set<String> set) {
        this.inspectTemplateClasspathResources = set;
    }
}

