/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDescriptorDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemMethodDescriptorDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemPropertyDescriptorDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemPropertyKind;
import com.xebialabs.deployit.core.api.dto.FullTaskInfo;
import com.xebialabs.deployit.core.api.dto.Permission;
import com.xebialabs.deployit.core.api.dto.Role;
import com.xebialabs.deployit.core.api.dto.RoleAssignment;
import com.xebialabs.deployit.core.api.dto.RolePermission;
import com.xebialabs.deployit.core.api.dto.StepInfo;
import com.xebialabs.deployit.core.api.dto.TaskInfo;
import com.xebialabs.deployit.core.api.dto.TaskInfos;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.task.DeploymentTask;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.TaskStep;
import com.xebialabs.deployit.task.TaskStepInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class DtoWriter {
    public ConfigurationItemDescriptorDto descriptorToDto(Descriptor descriptor) {
        Checks.checkNotNull((Object)descriptor, (String)"descriptor");
        ConfigurationItemDescriptorDto configurationItemDescriptorDto = new ConfigurationItemDescriptorDto();
        configurationItemDescriptorDto.setType(descriptor.getType().toString());
        Function<Type, String> function = new Function<Type, String>(){

            public String apply(Type type) {
                return type.toString();
            }
        };
        configurationItemDescriptorDto.setInterfaces((Set)Sets.newHashSet((Iterable)Collections2.transform((Collection)descriptor.getInterfaces(), (Function)function)));
        configurationItemDescriptorDto.setSuperClasses((List)Lists.newArrayList((Iterable)Collections2.transform((Collection)descriptor.getSuperClasses(), (Function)function)));
        Type type = descriptor.getDeployableType();
        configurationItemDescriptorDto.setMappingSourceType(type != null ? type.toString() : "");
        Type type2 = descriptor.getContainerType();
        configurationItemDescriptorDto.setMappingTargetType(type2 != null ? type2.toString() : "");
        configurationItemDescriptorDto.setDescription(descriptor.getDescription());
        configurationItemDescriptorDto.setRootName(descriptor.getRoot().getRootNodeName());
        for (PropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
            if (propertyDescriptor.isHidden()) continue;
            configurationItemDescriptorDto.addPropertyDescriptor(this.propertyDescriptorToDto(propertyDescriptor));
        }
        for (PropertyDescriptor propertyDescriptor : descriptor.getControlTasks()) {
            configurationItemDescriptorDto.addControlTask(this.methodDescriptorToDto((MethodDescriptor)propertyDescriptor));
        }
        return configurationItemDescriptorDto;
    }

    private ConfigurationItemMethodDescriptorDto methodDescriptorToDto(MethodDescriptor methodDescriptor) {
        ConfigurationItemMethodDescriptorDto configurationItemMethodDescriptorDto = new ConfigurationItemMethodDescriptorDto();
        configurationItemMethodDescriptorDto.setDescription(methodDescriptor.getDescription());
        configurationItemMethodDescriptorDto.setName(methodDescriptor.getName());
        return configurationItemMethodDescriptorDto;
    }

    private ConfigurationItemPropertyDescriptorDto propertyDescriptorToDto(PropertyDescriptor propertyDescriptor) {
        Type type;
        Checks.checkNotNull((Object)propertyDescriptor, (String)"propertydescriptor");
        ConfigurationItemPropertyDescriptorDto configurationItemPropertyDescriptorDto = new ConfigurationItemPropertyDescriptorDto();
        configurationItemPropertyDescriptorDto.setName(propertyDescriptor.getName());
        configurationItemPropertyDescriptorDto.setLabel(propertyDescriptor.getLabel());
        configurationItemPropertyDescriptorDto.setType(ConfigurationItemPropertyKind.valueOf((String)propertyDescriptor.getKind().toString()));
        if (propertyDescriptor.getEnumValues() != null) {
            configurationItemPropertyDescriptorDto.setEnumValues(propertyDescriptor.getEnumValues().toArray(new String[propertyDescriptor.getEnumValues().size()]));
        }
        configurationItemPropertyDescriptorDto.setCollectionMemberClassname((type = propertyDescriptor.getReferencedType()) != null ? type.toString() : "");
        configurationItemPropertyDescriptorDto.setPropertyClassname("");
        configurationItemPropertyDescriptorDto.setRequired(propertyDescriptor.isRequired());
        configurationItemPropertyDescriptorDto.setEditable(true);
        configurationItemPropertyDescriptorDto.setPassword(propertyDescriptor.isPassword());
        configurationItemPropertyDescriptorDto.setIdentifying(false);
        configurationItemPropertyDescriptorDto.setDiscoveryParam(false);
        configurationItemPropertyDescriptorDto.setDiscoveryRequired(false);
        configurationItemPropertyDescriptorDto.setCategory(propertyDescriptor.getCategory());
        configurationItemPropertyDescriptorDto.setSize(propertyDescriptor.getSize().toString());
        Object object = propertyDescriptor.getDefaultValue();
        configurationItemPropertyDescriptorDto.setDefaultValue(object == null ? null : object.toString());
        configurationItemPropertyDescriptorDto.setDescription(propertyDescriptor.getDescription());
        configurationItemPropertyDescriptorDto.setAsContainment(propertyDescriptor.isAsContainment());
        return configurationItemPropertyDescriptorDto;
    }

    public TaskInfos tasksToDto(List<Task> list) {
        TaskInfos taskInfos = new TaskInfos();
        for (Task task : list) {
            taskInfos.add(this.taskToDto(task));
        }
        return taskInfos;
    }

    public TaskInfo taskToDto(Task task) {
        return this.taskToDto(task, new TaskInfo());
    }

    public FullTaskInfo fullTaskToDto(Task task) {
        int n = 1;
        FullTaskInfo fullTaskInfo = this.taskToDto(task, new FullTaskInfo());
        for (TaskStep taskStep : task.getSteps()) {
            fullTaskInfo.addStep(this.taskStepInfoToDto(n++, (TaskStepInfo)taskStep));
        }
        return fullTaskInfo;
    }

    private <T extends TaskInfo> T taskToDto(Task task, T t) {
        Checks.checkNotNull((Object)task, (String)"task");
        Checks.checkNotNull((Object)task.getId(), (String)"id");
        t.setId(task.getId());
        t.setLabel(task.getLabel());
        t.setState(task.getState().name());
        t.setStartDate(task.getStartDate());
        t.setCompletionDate(task.getCompletionDate());
        t.setNrOfSteps(task.getNrOfSteps());
        t.setCurrentStepNr(task.getCurrentStepNr());
        t.setUser(task.getOwner());
        if (task instanceof DeploymentTask) {
            DeploymentTask deploymentTask = (DeploymentTask)task;
            t.setApplication(deploymentTask.getApplicationName());
            t.setVersion(deploymentTask.getApplicationVersion());
            t.setEnvironment(deploymentTask.getEnvironment());
            t.setFailureCount(deploymentTask.getFailureCount());
        }
        return t;
    }

    public StepInfo taskStepInfoToDto(int n, TaskStepInfo taskStepInfo) {
        Checks.checkNotNull((Object)taskStepInfo, (String)"step");
        StepInfo stepInfo = new StepInfo();
        stepInfo.setNr(n);
        stepInfo.setDescription(taskStepInfo.getDescription());
        stepInfo.setState(taskStepInfo.getState().name());
        stepInfo.setStartDate(taskStepInfo.getStartDate());
        stepInfo.setCompletionDate(taskStepInfo.getCompletionDate());
        stepInfo.setLog(taskStepInfo.getLog());
        return stepInfo;
    }

    public TaskInfo archivedTaskToDto(DeploymentTaskInfo deploymentTaskInfo) {
        Checks.checkNotNull((Object)deploymentTaskInfo, (String)"deploymentTask");
        return this.populateTaskInfo(deploymentTaskInfo, new TaskInfo());
    }

    public FullTaskInfo fullArchivedTaskToDto(DeploymentTaskInfo deploymentTaskInfo) {
        Checks.checkNotNull((Object)deploymentTaskInfo, (String)"deploymentTaskInfo");
        int n = 1;
        FullTaskInfo fullTaskInfo = this.populateTaskInfo(deploymentTaskInfo, new FullTaskInfo());
        for (TaskStepInfo taskStepInfo : deploymentTaskInfo.getSteps()) {
            fullTaskInfo.addStep(this.taskStepInfoToDto(n++, taskStepInfo));
        }
        return fullTaskInfo;
    }

    private <T extends TaskInfo> T populateTaskInfo(DeploymentTaskInfo deploymentTaskInfo, T t) {
        Checks.checkNotNull((Object)deploymentTaskInfo, (String)"deploymentTask");
        Checks.checkNotNull(t, (String)"taskInfo");
        t.setId(deploymentTaskInfo.getId());
        t.setLabel(String.format("Deployment of package:%s version:%s to env:%s", deploymentTaskInfo.getApplicationName(), deploymentTaskInfo.getApplicationVersion(), deploymentTaskInfo.getEnvironment()));
        t.setState(deploymentTaskInfo.getState().name());
        t.setStartDate(deploymentTaskInfo.getStartDate());
        t.setCompletionDate(deploymentTaskInfo.getCompletionDate());
        t.setNrOfSteps(deploymentTaskInfo.getSteps().size());
        t.setCurrentStepNr(deploymentTaskInfo.getCurrentStepNr());
        t.setUser(deploymentTaskInfo.getOwner());
        t.setEnvironment(deploymentTaskInfo.getEnvironment());
        t.setApplication(deploymentTaskInfo.getApplicationName());
        t.setVersion(deploymentTaskInfo.getApplicationVersion());
        return t;
    }

    public List<Role> writeRoles(List<com.xebialabs.deployit.security.Role> list) {
        return Lists.newArrayList((Iterable)Lists.transform(list, (Function)new Function<com.xebialabs.deployit.security.Role, Role>(){

            public Role apply(com.xebialabs.deployit.security.Role role) {
                return DtoWriter.this.writeRole(role);
            }
        }));
    }

    private Role writeRole(com.xebialabs.deployit.security.Role role) {
        return new Role(role.getId(), role.getName());
    }

    public List<RoleAssignment> writeRoleAssignments(List<com.xebialabs.deployit.security.Role> list) {
        ArrayList arrayList = Lists.newArrayList();
        for (com.xebialabs.deployit.security.Role role : list) {
            arrayList.add(new RoleAssignment(this.writeRole(role), (List)Lists.newArrayList((Iterable)role.getPrincipalsAssigned())));
        }
        return arrayList;
    }

    public List<RolePermission> writeRolePermissions(Multimap<com.xebialabs.deployit.security.Role, com.xebialabs.deployit.security.permission.Permission> multimap) {
        ArrayList arrayList = Lists.newArrayList();
        for (com.xebialabs.deployit.security.Role role : multimap.keySet()) {
            arrayList.add(new RolePermission(this.writeRole(role), this.writePermissions(multimap.get((Object)role))));
        }
        return arrayList;
    }

    private List<String> writePermissions(Collection<com.xebialabs.deployit.security.permission.Permission> collection) {
        return Lists.newArrayList((Iterable)Iterables.transform(collection, (Function)new Function<com.xebialabs.deployit.security.permission.Permission, String>(){

            public String apply(com.xebialabs.deployit.security.permission.Permission permission) {
                return permission.getPermissionName();
            }
        }));
    }

    public List<Permission> writeReferenceDataPermissions(com.xebialabs.deployit.security.permission.Permission[] permissionArray) {
        return Lists.newArrayList((Iterable)Iterables.transform(Arrays.asList(permissionArray), (Function)new Function<com.xebialabs.deployit.security.permission.Permission, Permission>(){

            public Permission apply(com.xebialabs.deployit.security.permission.Permission permission) {
                String string = permission.getRoot() != null ? permission.getRoot().getRootNodeName() : null;
                return new Permission(permission.getPermissionName(), permission.getLevel().name(), string);
            }
        }));
    }
}

