/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.ExportProxy;
import com.xebialabs.deployit.core.api.dto.FullTaskInfos;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.api.DtoWriter;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.task.TaskArchive;
import java.util.Collection;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class ExportResource
implements ExportProxy {
    @Autowired
    private TaskArchive taskArchive;
    @Autowired
    private DtoWriter dtoConverter;

    public Response getFullArchivedTasks() {
        return ResponseFactory.ok((Object)this.getFullTaskInfos(new ArchivedTaskSearchParameters())).build();
    }

    public Response getFullArchivedTasksInDateRange(Date date, Date date2) {
        Checks.checkNotNull((Object)date, (String)"beginDate");
        Checks.checkNotNull((Object)date2, (String)"endDate");
        ArchivedTaskSearchParameters archivedTaskSearchParameters = new ArchivedTaskSearchParameters();
        archivedTaskSearchParameters.createdBetween(date.getCalendar(), date2.getCalendar());
        return ResponseFactory.ok((Object)this.getFullTaskInfos(archivedTaskSearchParameters)).build();
    }

    private final FullTaskInfos getFullTaskInfos(ArchivedTaskSearchParameters archivedTaskSearchParameters) {
        FullTaskInfos fullTaskInfos = new FullTaskInfos();
        Collection collection = this.taskArchive.searchTasks(archivedTaskSearchParameters);
        for (DeploymentTaskInfo deploymentTaskInfo : collection) {
            fullTaskInfos.addTask(this.dtoConverter.fullArchivedTaskToDto(deploymentTaskInfo));
        }
        return fullTaskInfos;
    }
}

