/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.api.resteasy;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public class Date
implements Comparable<Date> {
    public static final String FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    protected static final String[] rfc822DateFormats = new String[]{"EEE, dd MMM yy HH:mm:ss z", "EEE, dd MMM yy HH:mm z", "EEE, dd MMM yyyy HH:mm:ss z", "EEE, dd MMM yyyy HH:mm z", "dd MMM yy HH:mm z", "dd MMM yy HH:mm:ss z", "dd MMM yyyy HH:mm z", "dd MMM yyyy HH:mm:ss z", "EEE MMM dd HH:mm:ss zzz yyyy", "EEE, dd MMM yyyy z", "yyyy-MM-dd'T'HH:mm:ss.SSSZ"};
    private Calendar calendar;
    private String dateString;

    public Date(Calendar calendar) {
        this(calendar, null);
    }

    public Date(Calendar calendar, String string) {
        this.calendar = calendar;
        if (this.calendar != null) {
            this.dateString = string != null ? new SimpleDateFormat(string).format(this.calendar.getTime()) : this.formatter(rfc822DateFormats[7]).format(this.calendar.getTime());
        }
    }

    private SimpleDateFormat formatter(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, Locale.ENGLISH);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat;
    }

    public Date(String string) {
        this.dateString = string;
        if (string != null) {
            this.calendar = this.parse(string);
        }
    }

    public static Date valueOf(String string) {
        return new Date(string);
    }

    private Calendar parse(String string) {
        if (string == null) {
            return null;
        }
        for (String string2 : rfc822DateFormats) {
            try {
                java.util.Date date = this.formatter(string2).parse(string);
                Calendar calendar = Calendar.getInstance(Locale.ENGLISH);
                calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
                calendar.setTime(date);
                return calendar;
            }
            catch (ParseException parseException) {
            }
        }
        throw new IllegalArgumentException(String.format("Cannot parse date %s", string));
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    @Override
    public int compareTo(Date date) {
        return this.calendar.compareTo(date.calendar);
    }

    public String toString() {
        return this.dateString;
    }
}

