/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere;

import com.google.common.base.Preconditions;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OperatingSystemFamily;
import java.io.Serializable;

public abstract class CmdLineArgument
implements Serializable {
    private static final String SPECIAL_CHARS_UNIX = " '\"\\;&|()${}*?";
    private static final String SPECIAL_CHARS_WINDOWS = " '\";&|()${}*?";
    private static final String EMPTY_ARGUMENT = "\"\"";

    public static CmdLineArgument arg(String string) {
        Preconditions.checkNotNull((Object)string, (Object)"Cannot create a null argument");
        return new Basic(string);
    }

    public static CmdLineArgument password(String string) {
        Preconditions.checkNotNull((Object)string, (Object)"Cannot create a null password argument");
        return new Password(string);
    }

    public static CmdLineArgument raw(String string) {
        Preconditions.checkNotNull((Object)string, (Object)"Cannot create a null password argument");
        return new Raw(string);
    }

    public static CmdLineArgument nested(CmdLine cmdLine) {
        Preconditions.checkNotNull((Object)cmdLine, (Object)"Cannot create a null nested command");
        return new Nested(cmdLine);
    }

    public final String toString(OperatingSystemFamily operatingSystemFamily, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        this.buildString(operatingSystemFamily, bl, stringBuilder);
        return stringBuilder.toString();
    }

    public abstract void buildString(OperatingSystemFamily var1, boolean var2, StringBuilder var3);

    protected void encodeString(String string, OperatingSystemFamily operatingSystemFamily, StringBuilder stringBuilder) {
        if (string.length() == 0) {
            stringBuilder.append(EMPTY_ARGUMENT);
            return;
        }
        switch (operatingSystemFamily) {
            case UNIX: {
                if (!this.containsAny(string, SPECIAL_CHARS_UNIX)) {
                    stringBuilder.append(string);
                    break;
                }
                this.encodeArgumentWithSpecialCharactersForUnix(string, stringBuilder);
                break;
            }
            case WINDOWS: {
                if (!this.containsAny(string, SPECIAL_CHARS_WINDOWS)) {
                    stringBuilder.append(string);
                    break;
                }
                this.encodeArgumentWithSpecialCharactersForWindows(string, stringBuilder);
                break;
            }
            default: {
                throw new RuntimeException("Unknown os " + (Object)((Object)operatingSystemFamily));
            }
        }
    }

    private boolean containsAny(String string, String string2) {
        for (char c : string2.toCharArray()) {
            if (string.indexOf(c) < 0) continue;
            return true;
        }
        return false;
    }

    private void encodeArgumentWithSpecialCharactersForWindows(String string, StringBuilder stringBuilder) {
        stringBuilder.append("\"");
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                stringBuilder.append(c);
            }
            stringBuilder.append(c);
        }
        stringBuilder.append("\"");
    }

    private void encodeArgumentWithSpecialCharactersForUnix(String string, StringBuilder stringBuilder) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (SPECIAL_CHARS_UNIX.indexOf(c) != -1) {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
    }

    private static class Nested
    extends CmdLineArgument {
        private final CmdLine line;

        public Nested(CmdLine cmdLine) {
            this.line = cmdLine;
        }

        @Override
        public void buildString(OperatingSystemFamily operatingSystemFamily, boolean bl, StringBuilder stringBuilder) {
            this.encodeString(this.line.toCommandLine(operatingSystemFamily, bl), operatingSystemFamily, stringBuilder);
        }

        public String toString() {
            return this.line.toString();
        }
    }

    private static class Password
    extends Basic {
        private static final String HIDDEN_PASSWORD = "********";

        public Password(String string) {
            super(string);
        }

        @Override
        public void buildString(OperatingSystemFamily operatingSystemFamily, boolean bl, StringBuilder stringBuilder) {
            if (bl) {
                stringBuilder.append(HIDDEN_PASSWORD);
            } else {
                super.buildString(operatingSystemFamily, bl, stringBuilder);
            }
        }

        @Override
        public String toString() {
            return HIDDEN_PASSWORD;
        }
    }

    private static class Basic
    extends Single {
        public Basic(String string) {
            super(string);
        }

        @Override
        public void buildString(OperatingSystemFamily operatingSystemFamily, boolean bl, StringBuilder stringBuilder) {
            String string = this.arg;
            this.encodeString(string, operatingSystemFamily, stringBuilder);
        }
    }

    private static class Raw
    extends Single {
        public Raw(String string) {
            super(string);
        }

        @Override
        public void buildString(OperatingSystemFamily operatingSystemFamily, boolean bl, StringBuilder stringBuilder) {
            if (this.arg.length() == 0) {
                stringBuilder.append(CmdLineArgument.EMPTY_ARGUMENT);
            } else {
                stringBuilder.append(this.arg);
            }
        }
    }

    private static abstract class Single
    extends CmdLineArgument {
        protected String arg;

        private Single(String string) {
            this.arg = string;
        }

        public String toString() {
            return this.arg;
        }
    }
}

