/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;

public class PDFontDescriptorDictionary
extends PDFontDescriptor
implements COSObjectable {
    private COSDictionary dic;
    private float capHeight = Float.NEGATIVE_INFINITY;
    private float xHeight = Float.NEGATIVE_INFINITY;

    public PDFontDescriptorDictionary() {
        this.dic = new COSDictionary();
        this.dic.setName("Type", "FontDescriptor");
    }

    public PDFontDescriptorDictionary(COSDictionary desc) {
        this.dic = desc;
    }

    public COSDictionary getCOSDictionary() {
        return this.dic;
    }

    public COSBase getCOSObject() {
        return this.dic;
    }

    public String getFontName() {
        String retval = null;
        COSName name = (COSName)this.dic.getDictionaryObject(COSName.FONT_NAME);
        if (name != null) {
            retval = name.getName();
        }
        return retval;
    }

    public void setFontName(String fontName) {
        COSName name = null;
        if (fontName != null) {
            name = COSName.getPDFName(fontName);
        }
        this.dic.setItem(COSName.FONT_NAME, (COSBase)name);
    }

    public String getFontFamily() {
        String retval = null;
        COSString name = (COSString)this.dic.getDictionaryObject(COSName.FONT_FAMILY);
        if (name != null) {
            retval = name.getString();
        }
        return retval;
    }

    public void setFontFamily(String fontFamily) {
        COSString name = null;
        if (fontFamily != null) {
            name = new COSString(fontFamily);
        }
        this.dic.setItem(COSName.FONT_FAMILY, (COSBase)name);
    }

    public float getFontWeight() {
        return this.dic.getFloat("FontWeight", 0.0f);
    }

    public void setFontWeight(float fontWeight) {
        this.dic.setFloat("FontWeight", fontWeight);
    }

    public String getFontStretch() {
        String retval = null;
        COSName name = (COSName)this.dic.getDictionaryObject(COSName.FONT_STRETCH);
        if (name != null) {
            retval = name.getName();
        }
        return retval;
    }

    public void setFontStretch(String fontStretch) {
        COSName name = null;
        if (fontStretch != null) {
            name = COSName.getPDFName(fontStretch);
        }
        this.dic.setItem(COSName.FONT_STRETCH, (COSBase)name);
    }

    public int getFlags() {
        return this.dic.getInt("Flags", 0);
    }

    public void setFlags(int flags) {
        this.dic.setInt("Flags", flags);
    }

    public PDRectangle getFontBoundingBox() {
        COSArray rect = (COSArray)this.dic.getDictionaryObject(COSName.FONT_BBOX);
        PDRectangle retval = null;
        if (rect != null) {
            retval = new PDRectangle(rect);
        }
        return retval;
    }

    public void setFontBoundingBox(PDRectangle rect) {
        COSArray array = null;
        if (rect != null) {
            array = rect.getCOSArray();
        }
        this.dic.setItem(COSName.FONT_BBOX, (COSBase)array);
    }

    public float getItalicAngle() {
        return this.dic.getFloat("ItalicAngle", 0.0f);
    }

    public void setItalicAngle(float angle) {
        this.dic.setFloat("ItalicAngle", angle);
    }

    public float getAscent() {
        return this.dic.getFloat("Ascent", 0.0f);
    }

    public void setAscent(float ascent) {
        this.dic.setFloat("Ascent", ascent);
    }

    public float getDescent() {
        return this.dic.getFloat("Descent", 0.0f);
    }

    public void setDescent(float descent) {
        this.dic.setFloat("Descent", descent);
    }

    public float getLeading() {
        return this.dic.getFloat("Leading", 0.0f);
    }

    public void setLeading(float leading) {
        this.dic.setFloat("Leading", leading);
    }

    public float getCapHeight() {
        if (this.capHeight == Float.NEGATIVE_INFINITY) {
            this.capHeight = Math.abs(this.dic.getFloat("CapHeight", 0.0f));
        }
        return this.capHeight;
    }

    public void setCapHeight(float capHeight) {
        this.dic.setFloat("CapHeight", capHeight);
        this.capHeight = capHeight;
    }

    public float getXHeight() {
        if (this.xHeight == Float.NEGATIVE_INFINITY) {
            this.xHeight = Math.abs(this.dic.getFloat("XHeight", 0.0f));
        }
        return this.xHeight;
    }

    public void setXHeight(float xHeight) {
        this.dic.setFloat("XHeight", xHeight);
        this.xHeight = xHeight;
    }

    public float getStemV() {
        return this.dic.getFloat("StemV", 0.0f);
    }

    public void setStemV(float stemV) {
        this.dic.setFloat("StemV", stemV);
    }

    public float getStemH() {
        return this.dic.getFloat("StemH", 0.0f);
    }

    public void setStemH(float stemH) {
        this.dic.setFloat("StemH", stemH);
    }

    public float getAverageWidth() {
        return this.dic.getFloat("AvgWidth", 0.0f);
    }

    public void setAverageWidth(float averageWidth) {
        this.dic.setFloat("AvgWidth", averageWidth);
    }

    public float getMaxWidth() {
        return this.dic.getFloat("MaxWidth", 0.0f);
    }

    public void setMaxWidth(float maxWidth) {
        this.dic.setFloat("MaxWidth", maxWidth);
    }

    public float getMissingWidth() {
        return this.dic.getFloat("MissingWidth", 0.0f);
    }

    public void setMissingWidth(float missingWidth) {
        this.dic.setFloat("MissingWidth", missingWidth);
    }

    public String getCharSet() {
        String retval = null;
        COSString name = (COSString)this.dic.getDictionaryObject(COSName.CHAR_SET);
        if (name != null) {
            retval = name.getString();
        }
        return retval;
    }

    public void setCharacterSet(String charSet) {
        COSString name = null;
        if (charSet != null) {
            name = new COSString(charSet);
        }
        this.dic.setItem(COSName.CHAR_SET, (COSBase)name);
    }

    public PDStream getFontFile() {
        PDStream retval = null;
        COSStream stream = (COSStream)this.dic.getDictionaryObject("FontFile");
        if (stream != null) {
            retval = new PDStream(stream);
        }
        return retval;
    }

    public void setFontFile(PDStream type1Stream) {
        this.dic.setItem("FontFile", (COSObjectable)type1Stream);
    }

    public PDStream getFontFile2() {
        PDStream retval = null;
        COSStream stream = (COSStream)this.dic.getDictionaryObject("FontFile2");
        if (stream != null) {
            retval = new PDStream(stream);
        }
        return retval;
    }

    public void setFontFile2(PDStream ttfStream) {
        this.dic.setItem("FontFile2", (COSObjectable)ttfStream);
    }

    public PDStream getFontFile3() {
        PDStream retval = null;
        COSStream stream = (COSStream)this.dic.getDictionaryObject("FontFile3");
        if (stream != null) {
            retval = new PDStream(stream);
        }
        return retval;
    }

    public void setFontFile3(PDStream stream) {
        this.dic.setItem("FontFile3", (COSObjectable)stream);
    }
}

