/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.springframework.core.io.ClassPathResource;

public class ReleaseInfo {
    private static final String UNKNOWN_VERSION = "0.0";
    private static final String UNKNOWN_DATE = "UNKNOWN_DATE";
    private String version;
    private String date;
    private static ReleaseInfo instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReleaseInfo() {
        ClassPathResource classPathResource = new ClassPathResource("com/xebialabs/deployit/release.properties");
        try {
            InputStream inputStream = classPathResource.getInputStream();
            try {
                Properties properties = new Properties();
                properties.load(inputStream);
                this.version = properties.getProperty("version", UNKNOWN_VERSION);
                this.date = properties.getProperty("timestamp", UNKNOWN_DATE);
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            this.version = UNKNOWN_VERSION;
            this.date = UNKNOWN_DATE;
        }
    }

    public String getVersion() {
        return this.version;
    }

    public String getDate() {
        return this.date;
    }

    public static synchronized ReleaseInfo getReleaseInfo() {
        if (instance == null) {
            instance = new ReleaseInfo();
        }
        return instance;
    }
}

