/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.replacement;

import com.samskivert.mustache.MustacheException;
import com.xebialabs.deployit.service.deployment.DictionaryValueException;
import com.xebialabs.deployit.service.replacement.MustachePlaceholders;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class MustachePlaceholderReplacer {
    public static final String IGNORE_PLACEHOLDER = "<ignore>";
    public static final String EMPTY_PLACEHOLDER = "<empty>";
    private final Map<String, ?> values;
    private final boolean interpretSpecialValues;

    public MustachePlaceholderReplacer(Map<String, ?> map) {
        this(map, true);
    }

    public MustachePlaceholderReplacer(Map<String, ?> map, boolean bl) {
        this.interpretSpecialValues = bl;
        this.values = new ReplacerMap(map);
    }

    public String replace(String string) throws DictionaryValueException {
        try {
            return MustachePlaceholders.newMustacheCompiler().compile(string).execute(this.values);
        }
        catch (MustacheException mustacheException) {
            throw new DictionaryValueException(mustacheException, "Could not replace dictionary keys in %s", string);
        }
    }

    public void replace(Reader reader, Writer writer) {
        MustachePlaceholders.newMustacheCompiler().compile(reader).execute(this.values, writer);
    }

    private class ReplacerMap
    extends HashMap<String, Object> {
        public ReplacerMap(Map<String, ?> map) {
            super(map);
        }

        @Override
        public Object get(Object object) {
            Object v = super.get(object);
            if (MustachePlaceholderReplacer.this.interpretSpecialValues) {
                if (MustachePlaceholderReplacer.IGNORE_PLACEHOLDER.equals(v)) {
                    return "{{" + object + "}}";
                }
                if (MustachePlaceholderReplacer.EMPTY_PLACEHOLDER.equals(v)) {
                    return "";
                }
            }
            return v;
        }
    }
}

