/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi.commons.batch;

import java.util.Iterator;
import java.util.ListIterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.spi.ItemId;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.batch.AbstractChangeLog;
import org.apache.jackrabbit.spi.commons.batch.Operation;
import org.apache.jackrabbit.spi.commons.batch.Operations;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsolidatingChangeLog
extends AbstractChangeLog<CancelableOperation> {
    private static final PathFactory PATH_FACTORY = PathFactoryImpl.getInstance();

    protected static Path getPath(NodeId parentId, Name name) throws RepositoryException {
        Path parent = parentId.getPath();
        if (!parent.isAbsolute()) {
            throw new IllegalArgumentException("Path not absoulte: " + parent);
        }
        return PATH_FACTORY.create(parent, name, true);
    }

    protected static Path getPath(ItemId itemId) {
        Path path = itemId.getPath();
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException("Path not absoulte: " + path);
        }
        return path;
    }

    public void addNode(NodeId parentId, Name nodeName, Name nodetypeName, String uuid) throws RepositoryException {
        this.addOperation(CancelableOperations.addNode(parentId, nodeName, nodetypeName, uuid));
    }

    public void addProperty(NodeId parentId, Name propertyName, QValue value) throws RepositoryException {
        this.addOperation(CancelableOperations.addProperty(parentId, propertyName, value));
    }

    public void addProperty(NodeId parentId, Name propertyName, QValue[] values) throws RepositoryException {
        this.addOperation(CancelableOperations.addProperty(parentId, propertyName, values));
    }

    public void move(NodeId srcNodeId, NodeId destParentNodeId, Name destName) throws RepositoryException {
        this.addOperation(CancelableOperations.move(srcNodeId, destParentNodeId, destName));
    }

    public void remove(ItemId itemId) throws RepositoryException {
        this.addOperation(CancelableOperations.remove(itemId));
    }

    public void reorderNodes(NodeId parentId, NodeId srcNodeId, NodeId beforeNodeId) throws RepositoryException {
        this.addOperation(CancelableOperations.reorderNodes(parentId, srcNodeId, beforeNodeId));
    }

    public void setMixins(NodeId nodeId, Name[] mixinNodeTypeNames) throws RepositoryException {
        this.addOperation(CancelableOperations.setMixins(nodeId, mixinNodeTypeNames));
    }

    public void setPrimaryType(NodeId nodeId, Name primaryNodeTypeName) throws RepositoryException {
        this.addOperation(CancelableOperations.setPrimaryType(nodeId, primaryNodeTypeName));
    }

    public void setValue(PropertyId propertyId, QValue value) throws RepositoryException {
        this.addOperation(CancelableOperations.setValue(propertyId, value));
    }

    public void setValue(PropertyId propertyId, QValue[] values) throws RepositoryException {
        this.addOperation(CancelableOperations.setValue(propertyId, values));
    }

    @Override
    public void addOperation(CancelableOperation op) throws RepositoryException {
        CancelableOperation otherOp = op;
        OperationsBackwardWithSentinel it = new OperationsBackwardWithSentinel();
        block6: while (it.hasNext()) {
            CancelableOperation thisOp = it.next();
            switch (thisOp.cancel(otherOp)) {
                case 0: {
                    it.remove();
                    continue block6;
                }
                case 1: {
                    return;
                }
                case 2: {
                    it.remove();
                    return;
                }
                case 3: {
                    super.addOperation(otherOp);
                    return;
                }
            }
            assert (false) : "Invalid case in switch";
        }
    }

    protected static final class CancelableOperations {
        private CancelableOperations() {
        }

        public static CancelableOperation empty() {
            return new Empty();
        }

        public static CancelableOperation addNode(NodeId parentId, Name nodeName, Name nodetypeName, String uuid) {
            return new AddNode(parentId, nodeName, nodetypeName, uuid);
        }

        public static CancelableOperation addProperty(NodeId parentId, Name propertyName, QValue value) {
            return new AddProperty(parentId, propertyName, value);
        }

        public static CancelableOperation addProperty(NodeId parentId, Name propertyName, QValue[] values) {
            return new AddProperty(parentId, propertyName, values);
        }

        public static CancelableOperation move(NodeId srcNodeId, NodeId destParentNodeId, Name destName) {
            return new Move(srcNodeId, destParentNodeId, destName);
        }

        public static CancelableOperation remove(ItemId itemId) {
            return new Remove(itemId);
        }

        public static CancelableOperation reorderNodes(NodeId parentId, NodeId srcNodeId, NodeId beforeNodeId) {
            return new ReorderNodes(parentId, srcNodeId, beforeNodeId);
        }

        public static CancelableOperation setMixins(NodeId nodeId, Name[] mixinNodeTypeNames) {
            return new SetMixins(nodeId, mixinNodeTypeNames);
        }

        public static CancelableOperation setPrimaryType(NodeId nodeId, Name primaryTypeName) {
            return new SetPrimaryType(nodeId, primaryTypeName);
        }

        public static CancelableOperation setValue(PropertyId propertyId, QValue value) {
            return new SetValue(propertyId, value);
        }

        public static CancelableOperation setValue(PropertyId propertyId, QValue[] values) {
            return new SetValue(propertyId, values);
        }

        public static class SetValue
        extends Operations.SetValue
        implements CancelableOperation {
            public SetValue(PropertyId propertyId, QValue value) {
                super(propertyId, value);
            }

            public SetValue(PropertyId propertyId, QValue[] values) {
                super(propertyId, values);
            }

            public int cancel(CancelableOperation other) throws RepositoryException {
                Path otherPath;
                Path thisPath;
                if (other instanceof Remove) {
                    Path otherPath2;
                    Path thisPath2 = ConsolidatingChangeLog.getPath((ItemId)this.propertyId);
                    return thisPath2.isDescendantOf(otherPath2 = ConsolidatingChangeLog.getPath(((Remove)other).itemId)) || thisPath2.equals(otherPath2) ? 0 : 3;
                }
                if (other instanceof SetValue && (thisPath = ConsolidatingChangeLog.getPath((ItemId)this.propertyId)).equals(otherPath = ConsolidatingChangeLog.getPath((ItemId)((SetValue)other).propertyId))) {
                    return 0;
                }
                return 3;
            }
        }

        public static class SetPrimaryType
        extends Operations.SetPrimaryType
        implements CancelableOperation {
            public SetPrimaryType(NodeId nodeId, Name primaryTypeName) {
                super(nodeId, primaryTypeName);
            }

            public int cancel(CancelableOperation other) throws RepositoryException {
                if (other instanceof Remove) {
                    Path otherPath;
                    Path thisPath = ConsolidatingChangeLog.getPath((ItemId)this.nodeId);
                    return thisPath.isDescendantOf(otherPath = ConsolidatingChangeLog.getPath(((Remove)other).itemId)) || thisPath.equals(otherPath) ? 0 : 3;
                }
                if (other instanceof SetPrimaryType) {
                    Path otherPath;
                    Path thisPath;
                    SetPrimaryType setPrimaryType = (SetPrimaryType)other;
                    if (this.primaryTypeName.equals(setPrimaryType.primaryTypeName) && (thisPath = ConsolidatingChangeLog.getPath((ItemId)this.nodeId)).equals(otherPath = ConsolidatingChangeLog.getPath((ItemId)setPrimaryType.nodeId))) {
                        return 0;
                    }
                }
                return 3;
            }
        }

        public static class SetMixins
        extends Operations.SetMixins
        implements CancelableOperation {
            public SetMixins(NodeId nodeId, Name[] mixinNodeTypeNames) {
                super(nodeId, mixinNodeTypeNames);
            }

            public int cancel(CancelableOperation other) throws RepositoryException {
                if (other instanceof Remove) {
                    Path otherPath;
                    Path thisPath = ConsolidatingChangeLog.getPath((ItemId)this.nodeId);
                    return thisPath.isDescendantOf(otherPath = ConsolidatingChangeLog.getPath(((Remove)other).itemId)) || thisPath.equals(otherPath) ? 0 : 3;
                }
                if (other instanceof SetMixins) {
                    Path otherPath;
                    Path thisPath;
                    SetMixins setMixin = (SetMixins)other;
                    if (this.mixinNodeTypeNames.length == setMixin.mixinNodeTypeNames.length && (thisPath = ConsolidatingChangeLog.getPath((ItemId)this.nodeId)).equals(otherPath = ConsolidatingChangeLog.getPath((ItemId)setMixin.nodeId))) {
                        for (int k = 0; k < this.mixinNodeTypeNames.length; ++k) {
                            if (this.mixinNodeTypeNames[k].equals(setMixin.mixinNodeTypeNames[k])) continue;
                            return 3;
                        }
                        return 0;
                    }
                }
                return 3;
            }
        }

        public static class ReorderNodes
        extends Operations.ReorderNodes
        implements CancelableOperation {
            public ReorderNodes(NodeId parentId, NodeId srcNodeId, NodeId beforeNodeId) {
                super(parentId, srcNodeId, beforeNodeId);
            }

            public int cancel(CancelableOperation other) throws RepositoryException {
                if (other instanceof Remove) {
                    Path otherPath;
                    Path thisPath = ConsolidatingChangeLog.getPath((ItemId)this.srcNodeId);
                    return thisPath.isDescendantOf(otherPath = ConsolidatingChangeLog.getPath(((Remove)other).itemId)) || thisPath.equals(otherPath) ? 0 : 3;
                }
                if (other instanceof ReorderNodes) {
                    Path otherPath;
                    Path thisPath = ConsolidatingChangeLog.getPath((ItemId)this.parentId);
                    return thisPath.equals(otherPath = ConsolidatingChangeLog.getPath((ItemId)((ReorderNodes)other).parentId)) && !this.hasSNS(this.srcNodeId) && !this.hasSNS(this.beforeNodeId) ? 0 : 3;
                }
                return 3;
            }

            private boolean hasSNS(NodeId nodeId) {
                return ConsolidatingChangeLog.getPath((ItemId)nodeId).getIndex() > 1;
            }
        }

        public static class Remove
        extends Operations.Remove
        implements CancelableOperation {
            public Remove(ItemId itemId) {
                super(itemId);
            }

            public int cancel(CancelableOperation other) {
                return 3;
            }
        }

        public static class Move
        extends Operations.Move
        implements CancelableOperation {
            public Move(NodeId srcNodeId, NodeId destParentNodeId, Name destName) {
                super(srcNodeId, destParentNodeId, destName);
            }

            public int cancel(CancelableOperation other) {
                return 3;
            }
        }

        public static class AddProperty
        extends Operations.AddProperty
        implements CancelableOperation {
            public AddProperty(NodeId parentId, Name propertyName, QValue value) {
                super(parentId, propertyName, value);
            }

            public AddProperty(NodeId parentId, Name propertyName, QValue[] values) {
                super(parentId, propertyName, values);
            }

            public int cancel(CancelableOperation other) throws RepositoryException {
                if (other instanceof Remove) {
                    Path otherPath;
                    Path thisPath = ConsolidatingChangeLog.getPath(this.parentId, this.propertyName);
                    if (thisPath.equals(otherPath = ConsolidatingChangeLog.getPath(((Remove)other).itemId))) {
                        return 2;
                    }
                    return thisPath.isDescendantOf(otherPath) ? 0 : 3;
                }
                if (other instanceof SetValue) {
                    Path otherPath;
                    SetValue setValue = (SetValue)other;
                    Path thisPath = ConsolidatingChangeLog.getPath(this.parentId, this.propertyName);
                    if (thisPath.equals(otherPath = ConsolidatingChangeLog.getPath((ItemId)setValue.propertyId))) {
                        if (!this.isMultivalued && setValue.values[0] == null) {
                            return 2;
                        }
                        if (this.values.length == setValue.values.length) {
                            for (int k = 0; k < this.values.length; ++k) {
                                if (this.values[k].equals(setValue.values[k])) continue;
                                return 3;
                            }
                            return 1;
                        }
                    }
                }
                return 3;
            }
        }

        public static class AddNode
        extends Operations.AddNode
        implements CancelableOperation {
            public AddNode(NodeId parentId, Name nodeName, Name nodetypeName, String uuid) {
                super(parentId, nodeName, nodetypeName, uuid);
            }

            public int cancel(CancelableOperation other) throws RepositoryException {
                if (other instanceof Remove) {
                    Path otherPath;
                    Path thisPath = ConsolidatingChangeLog.getPath(this.parentId, this.nodeName);
                    if (thisPath.equals(otherPath = ConsolidatingChangeLog.getPath(((Remove)other).itemId))) {
                        return 2;
                    }
                    return thisPath.isDescendantOf(otherPath) ? 0 : 3;
                }
                return 3;
            }
        }

        public static class Empty
        extends Operations.Empty
        implements CancelableOperation {
            public int cancel(CancelableOperation other) throws RepositoryException {
                return 3;
            }
        }
    }

    protected static interface CancelableOperation
    extends Operation {
        public static final int CANCEL_THIS = 0;
        public static final int CANCEL_OTHER = 1;
        public static final int CANCEL_BOTH = 2;
        public static final int CANCEL_NONE = 3;

        public int cancel(CancelableOperation var1) throws RepositoryException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OperationsBackwardWithSentinel
    implements Iterator<CancelableOperation> {
        private final ListIterator<CancelableOperation> it;
        private boolean last;
        private boolean done;

        private OperationsBackwardWithSentinel() {
            this.it = ConsolidatingChangeLog.this.operations.listIterator(ConsolidatingChangeLog.this.operations.size());
            this.last = !this.it.hasPrevious();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasPrevious() || this.last;
        }

        @Override
        public CancelableOperation next() {
            if (this.last) {
                this.done = true;
                return CancelableOperations.empty();
            }
            CancelableOperation o = this.it.previous();
            this.last = !this.it.hasPrevious();
            return o;
        }

        @Override
        public void remove() {
            if (this.done) {
                throw new IllegalStateException("Cannot remove last element");
            }
            this.it.remove();
        }
    }
}

