/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.core.api.QueryProxy;
import com.xebialabs.deployit.core.api.dto.Comparison;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDtos;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemIds;
import com.xebialabs.deployit.core.api.dto.PropertyValue;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.api.ConfigurationItemDtoWriter;
import com.xebialabs.deployit.core.rest.api.DtoReader;
import com.xebialabs.deployit.core.rest.api.SearchParameterFactory;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.service.comparison.Comparator;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class QueryResource
implements QueryProxy {
    public static final Predicate<ConfigurationItemData> hasReadRight = new Predicate<ConfigurationItemData>(){

        public boolean apply(ConfigurationItemData configurationItemData) {
            return Permission.READ.getPermissionHandler().hasPermission(configurationItemData.getId());
        }
    };
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ConfigurationItemDtoWriter dtoWriter;
    @Autowired
    private Comparator comparator;
    private static final Logger logger = LoggerFactory.getLogger(QueryResource.class);

    public Response list(@QueryParam(value="typeName") String string, @QueryParam(value="archetype") boolean bl, @QueryParam(value="page") long l, @QueryParam(value="resultsPerPage") long l2, @QueryParam(value="property") List<PropertyValue> list, String string2, String string3) {
        SearchParameters searchParameters = SearchParameterFactory.createSearchParam(string, l, l2, list, string2, string3);
        ConfigurationItemIds configurationItemIds = new ConfigurationItemIds();
        Collection collection = Collections2.transform((Collection)Collections2.filter((Collection)this.repositoryService.list(searchParameters), hasReadRight), DtoReader.ciDataToCiId);
        configurationItemIds.getConfigurationItemIds().addAll(collection);
        return ResponseFactory.ok((Object)configurationItemIds).build();
    }

    public Response readMultiple(ConfigurationItemIds configurationItemIds) {
        ConfigurationItemDtos configurationItemDtos = new ConfigurationItemDtos();
        Collection collection = Collections2.filter((Collection)Lists.transform((List)configurationItemIds.getConfigurationItemIds(), DtoReader.ciIdToCiData), hasReadRight);
        for (ConfigurationItemData configurationItemData : collection) {
            try {
                ConfigurationItem configurationItem = this.repositoryService.read(configurationItemData.getId());
                configurationItemDtos.add(this.dtoWriter.write(configurationItem));
            }
            catch (RuntimeException runtimeException) {
                logger.error("Could not read configuration item [{}]", (Object)configurationItemData);
                logger.error("Exception was: ", (Throwable)runtimeException);
            }
        }
        return ResponseFactory.ok((Object)configurationItemDtos).build();
    }

    public Response compare(String string, List<String> list) {
        ConfigurationItem configurationItem = this.repositoryService.read(string);
        ListMultimap listMultimap = this.comparator.compare(configurationItem, Lists.transform(list, (Function)new Function<String, ConfigurationItem>(){

            public ConfigurationItem apply(String string) {
                return QueryResource.this.repositoryService.read(string);
            }
        }));
        return ResponseFactory.ok((Object)Comparison.from((ListMultimap)listMultimap)).build();
    }

    public Response search(@QueryParam(value="typeName") String string, @QueryParam(value="before") Date date) {
        logger.info("Searching for all [{}] with last modified before [{}]", (Object)string, (Object)date);
        SearchParameters searchParameters = SearchParameterFactory.createSearchParam(string, 0L, -1L, Lists.newArrayList());
        searchParameters.setBefore(date.getCalendar());
        List list = this.repositoryService.list(searchParameters);
        logger.debug("Found ids: {}", (Object)list);
        return ResponseFactory.ok((Object)new ConfigurationItemIds(Lists.transform((List)list, DtoReader.ciDataToCiId))).build();
    }
}

