/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource.init;

import java.io.IOException;
import java.io.LineNumberReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.jdbc.datasource.init.CannotReadScriptException;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.ScriptStatementFailedException;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDatabasePopulator
implements DatabasePopulator {
    private static String DEFAULT_COMMENT_PREFIX = "--";
    private static String DEFAULT_STATEMENT_SEPARATOR = ";";
    private static final Log logger = LogFactory.getLog(ResourceDatabasePopulator.class);
    private List<Resource> scripts = new ArrayList<Resource>();
    private String sqlScriptEncoding;
    private String separator;
    private String commentPrefix = DEFAULT_COMMENT_PREFIX;
    private boolean continueOnError = false;
    private boolean ignoreFailedDrops = false;

    public void addScript(Resource script) {
        this.scripts.add(script);
    }

    public void setScripts(Resource[] scripts) {
        this.scripts = Arrays.asList(scripts);
    }

    public void setSqlScriptEncoding(String sqlScriptEncoding) {
        this.sqlScriptEncoding = sqlScriptEncoding;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setCommentPrefix(String commentPrefix) {
        this.commentPrefix = commentPrefix;
    }

    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    public void setIgnoreFailedDrops(boolean ignoreFailedDrops) {
        this.ignoreFailedDrops = ignoreFailedDrops;
    }

    @Override
    public void populate(Connection connection) throws SQLException {
        for (Resource script : this.scripts) {
            this.executeSqlScript(connection, this.applyEncodingIfNecessary(script), this.continueOnError, this.ignoreFailedDrops);
        }
    }

    private EncodedResource applyEncodingIfNecessary(Resource script) {
        if (script instanceof EncodedResource) {
            return (EncodedResource)script;
        }
        return new EncodedResource(script, this.sqlScriptEncoding);
    }

    private void executeSqlScript(Connection connection, EncodedResource resource, boolean continueOnError, boolean ignoreFailedDrops) throws SQLException {
        String script;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Executing SQL script from " + resource));
        }
        long startTime = System.currentTimeMillis();
        LinkedList<String> statements = new LinkedList<String>();
        try {
            script = this.readScript(resource);
        }
        catch (IOException ex) {
            throw new CannotReadScriptException(resource, (Throwable)ex);
        }
        String delimiter = this.separator;
        if (delimiter == null && !this.containsSqlScriptDelimiters(script, delimiter = DEFAULT_STATEMENT_SEPARATOR)) {
            delimiter = "\n";
        }
        this.splitSqlScript(script, delimiter, statements);
        int lineNumber = 0;
        Statement stmt = connection.createStatement();
        try {
            for (String statement : statements) {
                ++lineNumber;
                try {
                    stmt.execute(statement);
                    int rowsAffected = stmt.getUpdateCount();
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)(String.valueOf(rowsAffected) + " returned as updateCount for SQL: " + statement));
                }
                catch (SQLException ex) {
                    boolean dropStatement = StringUtils.startsWithIgnoreCase((String)statement.trim(), (String)"drop");
                    if (continueOnError || dropStatement && ignoreFailedDrops) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("Failed to execute SQL script statement at line " + lineNumber + " of resource " + resource + ": " + statement), (Throwable)ex);
                        continue;
                    }
                    throw new ScriptStatementFailedException(statement, lineNumber, resource, ex);
                }
            }
        }
        finally {
            try {
                stmt.close();
            }
            catch (Throwable ex) {
                logger.debug((Object)"Could not close JDBC Statement", ex);
            }
        }
        long elapsedTime = System.currentTimeMillis() - startTime;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Done executing SQL script from " + resource + " in " + elapsedTime + " ms."));
        }
    }

    private String readScript(EncodedResource resource) throws IOException {
        LineNumberReader lnr = new LineNumberReader(resource.getReader());
        String currentStatement = lnr.readLine();
        StringBuilder scriptBuilder = new StringBuilder();
        while (currentStatement != null) {
            if (StringUtils.hasText((String)currentStatement) && this.commentPrefix != null && !currentStatement.startsWith(this.commentPrefix)) {
                if (scriptBuilder.length() > 0) {
                    scriptBuilder.append('\n');
                }
                scriptBuilder.append(currentStatement);
            }
            currentStatement = lnr.readLine();
        }
        this.maybeAddSeparatorToScript(scriptBuilder);
        return scriptBuilder.toString();
    }

    private void maybeAddSeparatorToScript(StringBuilder scriptBuilder) {
        if (this.separator == null) {
            return;
        }
        String trimmed = this.separator.trim();
        if (trimmed.length() == this.separator.length()) {
            return;
        }
        if (scriptBuilder.lastIndexOf(trimmed) == scriptBuilder.length() - trimmed.length()) {
            scriptBuilder.append(this.separator.substring(trimmed.length()));
        }
    }

    private boolean containsSqlScriptDelimiters(String script, String delim) {
        boolean inLiteral = false;
        char[] content = script.toCharArray();
        int i = 0;
        while (i < script.length()) {
            if (content[i] == '\'') {
                boolean bl = inLiteral = !inLiteral;
            }
            if (!inLiteral && script.substring(i).startsWith(delim)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private void splitSqlScript(String script, String delim, List<String> statements) {
        sb = new StringBuilder();
        inLiteral = false;
        inEscape = false;
        content = script.toCharArray();
        i = 0;
        while (i < script.length()) {
            block8: {
                block9: {
                    block7: {
                        c = content[i];
                        if (!inEscape) break block7;
                        inEscape = false;
                        sb.append((char)c);
                        break block8;
                    }
                    if (c != 92) break block9;
                    inEscape = true;
                    sb.append((char)c);
                    break block8;
                }
                if (c == 39) {
                    v0 = inLiteral = inLiteral == false;
                }
                if (inLiteral) ** GOTO lbl32
                if (script.substring(i).startsWith(delim)) {
                    if (sb.length() > 0) {
                        statements.add(sb.toString());
                        sb = new StringBuilder();
                    }
                    i += delim.length() - 1;
                } else {
                    if (c == 10 || c == 9) {
                        c = 32;
                    }
lbl32:
                    // 4 sources

                    sb.append((char)c);
                }
            }
            ++i;
        }
        if (StringUtils.hasText((CharSequence)sb)) {
            statements.add(sb.toString());
        }
    }
}

