/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.step;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.generic.step.BaseDeploymentStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.OverthereFile;

public class ArtifactCopyStep
extends BaseDeploymentStep {
    private String targetPath;
    private boolean createTargetPath;
    private String targetFileName;
    private OverthereFile sourceFile;
    private String sourceFileDescription;
    private String description;

    public ArtifactCopyStep(int n, OverthereFile overthereFile, HostContainer hostContainer, String string) {
        super(n, hostContainer);
        this.sourceFile = overthereFile;
        this.targetPath = string;
        Preconditions.checkNotNull((Object)string);
    }

    @Override
    protected Step.Result doExecute() throws Exception {
        OverthereFile overthereFile;
        Preconditions.checkNotNull((Object)this.targetFileName);
        OverthereFile overthereFile2 = this.resolveSourceFile();
        Preconditions.checkNotNull((Object)overthereFile2);
        OverthereFile overthereFile3 = this.getRemoteConnection().getFile(this.targetPath);
        if (!overthereFile3.exists()) {
            if (this.createTargetPath) {
                ((DeploymentExecutionContext)this.getCtx()).logOutput("Creating path " + this.targetPath + " on host " + this.getContainer().getHost());
                overthereFile3.mkdirs();
            } else if (overthereFile2.isFile()) {
                ((DeploymentExecutionContext)this.getCtx()).logError("Path " + this.targetPath + " on host " + this.getContainer().getHost() + " does not exist.");
                return Step.Result.Fail;
            }
        }
        if (overthereFile2.isDirectory()) {
            overthereFile = overthereFile3;
        } else {
            overthereFile = overthereFile3.getFile(this.getTargetFileName());
            if (overthereFile.exists()) {
                ((DeploymentExecutionContext)this.getCtx()).logOutput(overthereFile.getPath() + " already exists on host " + this.getContainer().getHost() + ". Will replace.");
                overthereFile.delete();
            }
        }
        ((DeploymentExecutionContext)this.getCtx()).logOutput("Copying " + overthereFile2.getPath() + " to " + overthereFile.getPath() + " on host " + this.getContainer().getHost());
        overthereFile2.copyTo(overthereFile);
        return Step.Result.Success;
    }

    protected OverthereFile resolveSourceFile() {
        Preconditions.checkNotNull((Object)this.sourceFile);
        return this.sourceFile;
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            return "Copy " + this.getSourceFileDescription() + " to " + this.getContainer().getHost();
        }
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getSourceFileDescription() {
        return this.sourceFileDescription;
    }

    public void setSourceFileDescription(String string) {
        this.sourceFileDescription = string;
    }

    public boolean isCreateTargetPath() {
        return this.createTargetPath;
    }

    public void setCreateTargetPath(boolean bl) {
        this.createTargetPath = bl;
    }

    public String getTargetFileName() {
        return this.targetFileName;
    }

    public void setTargetFileName(String string) {
        this.targetFileName = string;
    }
}

