/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs.winrm.connector;

import com.xebialabs.overthere.cifs.winrm.connector.LaxTrustManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.SecureRandom;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LaxSSLSocketFactory
extends SSLSocketFactory {
    private SSLSocketFactory factory;
    private static final Logger logger = LoggerFactory.getLogger(LaxSSLSocketFactory.class);

    public LaxSSLSocketFactory() {
        try {
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(null, new TrustManager[]{new LaxTrustManager()}, new SecureRandom());
            this.factory = sSLContext.getSocketFactory();
        }
        catch (Exception exception) {
            logger.error("Couldn't setup lax SSL context", (Throwable)exception);
        }
    }

    public static SocketFactory getDefault() {
        return new LaxSSLSocketFactory();
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.factory.createSocket();
    }

    @Override
    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
        return this.factory.createSocket(socket, string, n, bl);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        return this.factory.createSocket(inetAddress, n, inetAddress2, n2);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        return this.factory.createSocket(inetAddress, n);
    }

    @Override
    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        return this.factory.createSocket(string, n, inetAddress, n2);
    }

    @Override
    public Socket createSocket(String string, int n) throws IOException {
        return this.factory.createSocket(string, n);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }
}

