/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.google.common.base.Preconditions;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.ssh.SshInteractiveSudoPasswordHandlingStream;
import com.xebialabs.overthere.ssh.SshProcess;
import com.xebialabs.overthere.ssh.SshSudoConnection;
import java.io.InputStream;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.transport.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SshInteractiveSudoConnection
extends SshSudoConnection {
    private String passwordPromptRegex;
    private static final Logger logger = LoggerFactory.getLogger(SshInteractiveSudoConnection.class);

    public SshInteractiveSudoConnection(String string, ConnectionOptions connectionOptions, AddressPortMapper addressPortMapper) {
        super(string, connectionOptions, addressPortMapper);
        this.passwordPromptRegex = connectionOptions.get("sudoPasswordPromptRegex", ".*[Pp]assword.*:");
        Preconditions.checkArgument((!this.passwordPromptRegex.endsWith("*") ? 1 : 0) != 0, (Object)"sudoPasswordPromptRegex should not end in a wildcard");
        Preconditions.checkArgument((!this.passwordPromptRegex.endsWith("?") ? 1 : 0) != 0, (Object)"sudoPasswordPromptRegex should not end in a wildcard");
        Preconditions.checkArgument((this.password != null ? 1 : 0) != 0, (String)"Cannot start a ssh:%s: connection without a password", (Object[])new Object[]{this.sshConnectionType.toString().toLowerCase()});
        if (!this.allocateDefaultPty && this.allocatePty == null) {
            logger.warn("SSH Interactive Sudo requires a PTY, allocating a default one.");
            this.allocateDefaultPty = true;
        }
    }

    @Override
    protected SshProcess createProcess(Session session, CmdLine cmdLine) throws TransportException, ConnectionException {
        return new SshProcess(this, this.os, session, cmdLine){

            @Override
            public InputStream getStdout() {
                return new SshInteractiveSudoPasswordHandlingStream(super.getStdout(), this.getStdin(), SshInteractiveSudoConnection.this.password, SshInteractiveSudoConnection.this.passwordPromptRegex);
            }
        };
    }
}

