/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap.server;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.authn.AuthenticationInterceptor;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.exception.ExceptionInterceptor;
import org.apache.directory.server.core.normalization.NormalizationInterceptor;
import org.apache.directory.server.core.operational.OperationalAttributeInterceptor;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmPartition;
import org.apache.directory.server.core.referral.ReferralInterceptor;
import org.apache.directory.server.core.subtree.SubentryInterceptor;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.protocol.shared.store.LdifFileLoader;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.shared.ldap.exception.LdapNameNotFoundException;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.Lifecycle;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.Assert;

public class ApacheDSContainer
implements InitializingBean,
DisposableBean,
Lifecycle,
ApplicationContextAware {
    private final Log logger = LogFactory.getLog(this.getClass());
    final DefaultDirectoryService service;
    LdapServer server;
    private ApplicationContext ctxt;
    private File workingDir;
    private boolean running;
    private final String ldifResources;
    private final JdbmPartition partition;
    private final String root;
    private int port = 53389;

    public ApacheDSContainer(String root, String ldifs) throws Exception {
        this.ldifResources = ldifs;
        this.service = new DefaultDirectoryService();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new NormalizationInterceptor());
        list.add(new AuthenticationInterceptor());
        list.add(new ReferralInterceptor());
        list.add(new ExceptionInterceptor());
        list.add(new OperationalAttributeInterceptor());
        list.add(new SubentryInterceptor());
        this.service.setInterceptors(list);
        this.partition = new JdbmPartition();
        this.partition.setId("rootPartition");
        this.partition.setSuffix(root);
        this.root = root;
        this.service.addPartition((Partition)this.partition);
        this.service.setExitVmOnShutdown(false);
        this.service.setShutdownHookEnabled(false);
        this.service.getChangeLog().setEnabled(false);
        this.service.setDenormalizeOpAttrsEnabled(true);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.workingDir == null) {
            String apacheWorkDir = System.getProperty("apacheDSWorkDir");
            if (apacheWorkDir == null) {
                apacheWorkDir = System.getProperty("java.io.tmpdir") + File.separator + "apacheds-spring-security";
            }
            this.setWorkingDirectory(new File(apacheWorkDir));
        }
        this.server = new LdapServer();
        this.server.setDirectoryService((DirectoryService)this.service);
        this.server.setTransports(new Transport[]{new TcpTransport(this.port)});
        this.start();
    }

    public void destroy() throws Exception {
        this.stop();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.ctxt = applicationContext;
    }

    public void setWorkingDirectory(File workingDir) {
        Assert.notNull((Object)workingDir);
        this.logger.info((Object)("Setting working directory for LDAP_PROVIDER: " + workingDir.getAbsolutePath()));
        if (workingDir.exists()) {
            throw new IllegalArgumentException("The specified working directory '" + workingDir.getAbsolutePath() + "' already exists. Another directory service instance may be using it or it may be from a " + " previous unclean shutdown. Please confirm and delete it or configure a different " + "working directory");
        }
        this.workingDir = workingDir;
        this.service.setWorkingDirectory(workingDir);
    }

    public void setPort(int port) {
        this.port = port;
    }

    public DefaultDirectoryService getService() {
        return this.service;
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        if (this.service.isStarted()) {
            throw new IllegalStateException("DirectoryService is already running.");
        }
        this.logger.info((Object)"Starting directory server...");
        try {
            this.service.startup();
            this.server.start();
        }
        catch (Exception e) {
            this.logger.error((Object)"Server startup failed ", (Throwable)e);
            return;
        }
        try {
            this.service.getAdminSession().lookup(this.partition.getSuffixDn());
        }
        catch (LdapNameNotFoundException e) {
            try {
                LdapDN dn = new LdapDN(this.root);
                Assert.isTrue((boolean)this.root.startsWith("dc="));
                String dc = this.root.substring(3, this.root.indexOf(44));
                ServerEntry entry = this.service.newEntry(dn);
                entry.add("objectClass", new String[]{"top", "domain", "extensibleObject"});
                entry.add("dc", new String[]{dc});
                this.service.getAdminSession().add(entry);
            }
            catch (Exception e1) {
                this.logger.error((Object)"Failed to create dc entry", (Throwable)e1);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Lookup failed", (Throwable)e);
        }
        this.running = true;
        try {
            this.importLdifs();
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to import LDIF file(s)", (Throwable)e);
        }
    }

    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.logger.info((Object)"Shutting down directory server ...");
        try {
            this.server.stop();
            this.service.shutdown();
        }
        catch (Exception e) {
            this.logger.error((Object)"Shutdown failed", (Throwable)e);
            return;
        }
        this.running = false;
        if (this.workingDir.exists()) {
            this.logger.info((Object)("Deleting working directory " + this.workingDir.getAbsolutePath()));
            this.deleteDir(this.workingDir);
        }
    }

    private void importLdifs() throws Exception {
        String ldifFile;
        Resource[] ldifs = this.ctxt == null ? new PathMatchingResourcePatternResolver().getResources(this.ldifResources) : this.ctxt.getResources(this.ldifResources);
        if (ldifs == null || ldifs.length == 0) {
            return;
        }
        if (ldifs.length == 1) {
            try {
                ldifFile = ldifs[0].getFile().getAbsolutePath();
            }
            catch (IOException e) {
                ldifFile = ldifs[0].getURI().toString();
            }
        } else {
            throw new IllegalArgumentException("More than one LDIF resource found with the supplied pattern:" + this.ldifResources);
        }
        this.logger.info((Object)("Loading LDIF file: " + ldifFile));
        LdifFileLoader loader = new LdifFileLoader(this.service.getAdminSession(), ldifFile);
        loader.execute();
    }

    private boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children;
            for (String child : children = dir.list()) {
                boolean success = this.deleteDir(new File(dir, child));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public boolean isRunning() {
        return this.running;
    }
}

