/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.inspection;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.inspection.InspectionExecutionContext;
import com.xebialabs.deployit.plugin.api.inspection.InspectionPlanningContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InspectionContext
implements InspectionExecutionContext,
InspectionPlanningContext,
DeploymentExecutionContext {
    private ExecutionContext context;
    private Map<String, Object> attributes;
    private Logger stepLogger;
    private List<Step> steps = Lists.newArrayList();
    private AtomicInteger currentStepIndex = new AtomicInteger(0);
    private List<ConfigurationItem> discovered = Lists.newArrayList();
    private List<ConfigurationItem> inspected = Lists.newArrayList();

    public InspectionContext(ExecutionContext executionContext) {
        this.context = (ExecutionContext)Preconditions.checkNotNull((Object)executionContext);
    }

    public InspectionContext(Map<String, Object> map) {
        this.attributes = (Map)Preconditions.checkNotNull(map);
    }

    public void startStepExecution(Step<?> step) {
        if (this.attributes != null) {
            this.stepLogger = LoggerFactory.getLogger(step.getClass());
        }
    }

    public void addStep(Step step) {
        this.steps.add(step);
    }

    public void discovered(ConfigurationItem configurationItem) {
        this.discovered.add(configurationItem);
    }

    void inspected(ConfigurationItem configurationItem) {
        this.discovered.remove(configurationItem);
        this.inspected.add(configurationItem);
    }

    public void logOutput(String string) {
        if (this.context != null) {
            this.context.logOutput(string);
        }
        if (this.stepLogger != null) {
            this.stepLogger.info(string);
        }
    }

    public void logError(String string) {
        if (this.context != null) {
            this.context.logError(string);
        }
        if (this.stepLogger != null) {
            this.stepLogger.error(string);
        }
    }

    public void logError(String string, Throwable throwable) {
        if (this.context != null) {
            this.context.logError(string, throwable);
        }
        if (this.stepLogger != null) {
            this.stepLogger.error(string, throwable);
        }
    }

    public Object getAttribute(String string) {
        if (this.context != null) {
            return this.context.getAttribute(string);
        }
        if (this.attributes != null) {
            return this.attributes.get(string);
        }
        throw new IllegalStateException(this + " has no context and no attributes");
    }

    public void setAttribute(String string, Object object) {
        if (this.context != null) {
            this.context.setAttribute(string, object);
        }
        if (this.attributes != null) {
            this.attributes.put(string, object);
        }
    }

    List<ConfigurationItem> getDiscovered() {
        return this.discovered;
    }

    public List<ConfigurationItem> getInspected() {
        return this.inspected;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public Step getNextStep() {
        if (this.currentStepIndex.get() < this.steps.size()) {
            return this.steps.get(this.currentStepIndex.getAndIncrement());
        }
        return null;
    }
}

