/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.api.resteasy;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.core.api.resteasy.InternalServerErrorClientResponseInterceptor;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.jboss.resteasy.client.core.ClientErrorInterceptor;
import org.jboss.resteasy.plugins.providers.ByteArrayProvider;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.plugins.providers.StringTextStar;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBElementProvider;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBXmlRootElementProvider;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBXmlSeeAlsoProvider;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBXmlTypeProvider;
import org.jboss.resteasy.plugins.providers.jaxb.XmlJAXBContextFinder;
import org.jboss.resteasy.plugins.providers.multipart.ListMultipartReader;
import org.jboss.resteasy.plugins.providers.multipart.ListMultipartWriter;
import org.jboss.resteasy.plugins.providers.multipart.MapMultipartFormDataReader;
import org.jboss.resteasy.plugins.providers.multipart.MapMultipartFormDataWriter;
import org.jboss.resteasy.plugins.providers.multipart.MimeMultipartProvider;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormAnnotationReader;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormAnnotationWriter;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataReader;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataWriter;
import org.jboss.resteasy.plugins.providers.multipart.MultipartReader;
import org.jboss.resteasy.plugins.providers.multipart.MultipartRelatedReader;
import org.jboss.resteasy.plugins.providers.multipart.MultipartRelatedWriter;
import org.jboss.resteasy.plugins.providers.multipart.MultipartWriter;
import org.jboss.resteasy.plugins.providers.multipart.XopWithMultipartRelatedReader;
import org.jboss.resteasy.plugins.providers.multipart.XopWithMultipartRelatedWriter;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.interception.PostProcessInterceptor;
import org.jboss.resteasy.spi.interception.PreProcessInterceptor;

public class ResteasyHelper {
    public static ResteasyProviderFactoryBuilder buildDefaultResteasyProviderFactory() {
        ResteasyProviderFactory resteasyProviderFactory = ResteasyProviderFactory.getInstance();
        ResteasyProviderFactoryBuilder resteasyProviderFactoryBuilder = new ResteasyProviderFactoryBuilder(resteasyProviderFactory);
        resteasyProviderFactoryBuilder.addGenericProviders().addJaxbProviders().addMultipartProviders();
        resteasyProviderFactoryBuilder.addClientErrorInterceptor(new InternalServerErrorClientResponseInterceptor());
        return resteasyProviderFactoryBuilder;
    }

    public static class ResteasyProviderFactoryBuilder {
        private ResteasyProviderFactory factory;
        private List<Class<? extends MessageBodyReader<?>>> readers = Lists.newArrayList();
        private List<Class<? extends MessageBodyWriter<?>>> writers = Lists.newArrayList();
        private List<ClientErrorInterceptor> errorInterceptors = Lists.newArrayList();
        private List<Class<? extends ContextResolver<?>>> contextResolvers = Lists.newArrayList();
        private List<Class<? extends ExceptionMapper<?>>> exceptionMappers = Lists.newArrayList();
        private List<Class<? extends PreProcessInterceptor>> preProcessInterceptors = Lists.newArrayList();
        private List<Class<? extends PostProcessInterceptor>> postProcessInterceptors = Lists.newArrayList();

        private ResteasyProviderFactoryBuilder(ResteasyProviderFactory resteasyProviderFactory) {
            this.factory = resteasyProviderFactory;
        }

        private void registerWriters() {
            for (Class<? extends MessageBodyWriter<?>> clazz : this.writers) {
                this.factory.addMessageBodyWriter(clazz);
            }
        }

        private void registerReaders() {
            for (Class<? extends MessageBodyReader<?>> clazz : this.readers) {
                this.factory.addMessageBodyReader(clazz);
            }
        }

        private void registerClientErrorInterceptors() {
            for (ClientErrorInterceptor clientErrorInterceptor : this.errorInterceptors) {
                this.factory.addClientErrorInterceptor(clientErrorInterceptor);
            }
        }

        private void registerContextResolvers() {
            for (Class<? extends ContextResolver<?>> clazz : this.contextResolvers) {
                this.factory.addContextResolver(clazz);
            }
        }

        private void registerExceptionMappers() {
            for (Class<? extends ExceptionMapper<?>> clazz : this.exceptionMappers) {
                this.factory.addExceptionMapper(clazz);
            }
        }

        private void registerInterceptors() {
            for (Class<? extends PreProcessInterceptor> clazz : this.preProcessInterceptors) {
                this.factory.getServerPreProcessInterceptorRegistry().register(clazz);
            }
            for (Class<? extends PreProcessInterceptor> clazz : this.postProcessInterceptors) {
                this.factory.getServerPostProcessInterceptorRegistry().register(clazz);
            }
        }

        public ResteasyProviderFactoryBuilder addReader(Class<? extends MessageBodyReader<?>> ... classArray) {
            this.readers.addAll(Arrays.asList(classArray));
            return this;
        }

        public ResteasyProviderFactoryBuilder addWriter(Class<? extends MessageBodyWriter<?>> ... classArray) {
            this.writers.addAll(Arrays.asList(classArray));
            return this;
        }

        public ResteasyProviderFactoryBuilder addContextResolver(Class<? extends ContextResolver<?>> ... classArray) {
            this.contextResolvers.addAll(Arrays.asList(classArray));
            return this;
        }

        public ResteasyProviderFactoryBuilder addClientErrorInterceptor(ClientErrorInterceptor ... clientErrorInterceptorArray) {
            this.errorInterceptors.addAll(Arrays.asList(clientErrorInterceptorArray));
            return this;
        }

        public ResteasyProviderFactoryBuilder addExceptionMapper(Class<? extends ExceptionMapper<?>> ... classArray) {
            this.exceptionMappers.addAll(Arrays.asList(classArray));
            return this;
        }

        public ResteasyProviderFactoryBuilder addPreProcessInterceptor(Class<? extends PreProcessInterceptor> ... classArray) {
            this.preProcessInterceptors.addAll(Arrays.asList(classArray));
            return this;
        }

        public ResteasyProviderFactoryBuilder addPostProcessInterceptor(Class<? extends PostProcessInterceptor> ... classArray) {
            this.postProcessInterceptors.addAll(Arrays.asList(classArray));
            return this;
        }

        public void build() {
            this.registerReaders();
            this.registerWriters();
            this.registerClientErrorInterceptors();
            this.registerContextResolvers();
            this.registerExceptionMappers();
            this.registerInterceptors();
            try {
                RegisterBuiltin.registerProviders((ResteasyProviderFactory)this.factory);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        private ResteasyProviderFactoryBuilder addGenericProviders() {
            this.addReaderWriter(StringTextStar.class);
            this.addReaderWriter(ByteArrayProvider.class);
            return this;
        }

        private <T extends MessageBodyReader<?> & MessageBodyWriter<?>> ResteasyProviderFactoryBuilder addReaderWriter(Class<T> clazz) {
            this.addReader(clazz);
            this.addWriter(clazz);
            return this;
        }

        private ResteasyProviderFactoryBuilder addMultipartProviders() {
            this.addReader(MultipartReader.class, MultipartRelatedReader.class, MultipartFormDataReader.class, ListMultipartReader.class, MapMultipartFormDataReader.class, MultipartFormAnnotationReader.class, MimeMultipartProvider.class, XopWithMultipartRelatedReader.class);
            this.addWriter(MultipartWriter.class, MultipartRelatedWriter.class, MultipartFormDataWriter.class, ListMultipartWriter.class, MapMultipartFormDataWriter.class, MultipartFormAnnotationWriter.class, MimeMultipartProvider.class, XopWithMultipartRelatedWriter.class);
            return this;
        }

        private ResteasyProviderFactoryBuilder addJaxbProviders() {
            this.addReader(JAXBXmlRootElementProvider.class, JAXBXmlTypeProvider.class, JAXBXmlSeeAlsoProvider.class, JAXBElementProvider.class);
            this.addWriter(JAXBXmlRootElementProvider.class, JAXBXmlTypeProvider.class, JAXBXmlSeeAlsoProvider.class, JAXBElementProvider.class);
            this.addContextResolver(XmlJAXBContextFinder.class);
            return this;
        }
    }
}

