/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.fork;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.tika.fork.ForkSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ForkServer
extends ClassLoader {
    public static final byte ERROR = -1;
    public static final byte REPLY = 0;
    public static final byte ECHO = 1;
    public static final byte FIND_RESOURCE = 2;
    public static final byte FIND_RESOURCES = 3;
    private final DataInputStream input;
    private final DataOutputStream output;
    private int count = 0;

    public static void main(String[] args) throws Exception {
        ForkServer server = new ForkServer(System.in, System.out);
        Thread.currentThread().setContextClassLoader(server);
        System.setIn(new ByteArrayInputStream(new byte[0]));
        System.setOut(System.err);
        server.run();
    }

    public ForkServer(InputStream input, OutputStream output) throws IOException {
        this.input = new DataInputStream(input);
        this.output = new DataOutputStream(output);
    }

    public void run() throws IOException {
        int b;
        while ((b = this.input.read()) != -1) {
            if (b != 1) continue;
            try {
                Object message = ForkSerializer.deserialize(this.input, this);
                this.output.write(1);
                ForkSerializer.serialize(this.output, "echo: " + message);
            }
            catch (ClassNotFoundException e) {
                this.output.write(-1);
                ForkSerializer.serialize(this.output, e);
            }
            this.output.flush();
        }
    }

    @Override
    protected synchronized URL findResource(String name) {
        try {
            this.output.write(2);
            this.output.writeUTF(name);
            this.output.flush();
            if (this.input.readBoolean()) {
                return this.readStreamToFile().toURI().toURL();
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected synchronized Enumeration<URL> findResources(String name) throws IOException {
        this.output.write(2);
        this.output.writeUTF(name);
        this.output.flush();
        ArrayList<URL> resources = new ArrayList<URL>();
        while (this.input.readBoolean()) {
            resources.add(this.readStreamToFile().toURI().toURL());
        }
        return Collections.enumeration(resources);
    }

    @Override
    protected synchronized Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            this.output.write(2);
            this.output.writeUTF(name.replace('.', '/') + ".class");
            this.output.flush();
            if (this.input.readBoolean()) {
                byte[] data = this.readStreamToMemory();
                return this.defineClass(name, data, 0, data.length);
            }
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ClassNotFoundException("Unable load class " + name, e);
        }
    }

    private byte[] readStreamToMemory() throws IOException {
        int n;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        byte[] buffer = new byte[65535];
        while ((n = this.input.readUnsignedShort()) > 0) {
            this.input.readFully(buffer, 0, n);
            stream.write(buffer, 0, n);
        }
        return stream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File readStreamToFile() throws IOException {
        File file = new File("resource-" + this.count++ + ".bin");
        FileOutputStream stream = new FileOutputStream(file);
        try {
            int n;
            byte[] buffer = new byte[65535];
            while ((n = this.input.readUnsignedShort()) > 0) {
                this.input.readFully(buffer, 0, n);
                ((OutputStream)stream).write(buffer, 0, n);
            }
        }
        finally {
            ((OutputStream)stream).close();
        }
        return file;
    }
}

