/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.deployed;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifacts;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.PlaceholderReplacer;
import com.xebialabs.deployit.plugin.api.validation.Placeholders;
import com.xebialabs.deployit.plugin.generic.deployed.AbstractDeployedArtifact;
import com.xebialabs.deployit.plugin.generic.step.ArtifactCopyStep;
import com.xebialabs.deployit.plugin.generic.step.ArtifactDeleteStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.OverthereFile;
import java.util.Map;

@Metadata(virtual=true, description="An artifact deployed on a generic container")
@Placeholders
public class CopiedArtifact<D extends DeployableArtifact>
extends AbstractDeployedArtifact<D>
implements DerivedArtifact<D> {
    private boolean useDescriptionGeneratedByStep = false;
    private OverthereFile placeholderProcessedFile;
    @Property(description="A Map containing all the placeholders mapped to their values. Special values are &lt;ignore&gt; or &lt;empty&gt;", required=false)
    private Map<String, String> placeholders = Maps.newHashMap();

    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    public void setPlaceholders(Map<String, String> map) {
        this.placeholders = map;
    }

    public OverthereFile getFile() {
        return this.placeholderProcessedFile;
    }

    public void setFile(OverthereFile overthereFile) {
        this.placeholderProcessedFile = overthereFile;
    }

    public D getSourceArtifact() {
        return (D)((DeployableArtifact)this.getDeployable());
    }

    public void initFile(PlaceholderReplacer placeholderReplacer) {
        Artifacts.replacePlaceholders((DerivedArtifact)this, (PlaceholderReplacer)placeholderReplacer);
    }

    @Create
    public void executeCreate(DeploymentPlanningContext deploymentPlanningContext) {
        deploymentPlanningContext.addStep((DeploymentStep)this.createArtifactCopyStep());
    }

    protected ArtifactCopyStep createArtifactCopyStep() {
        ArtifactCopyStep artifactCopyStep = new ArtifactCopyStep(this.getCreateOrder(), this.getFile(), (HostContainer)this.getContainer(), this.getTargetDirectory());
        artifactCopyStep.setCreateTargetPath(this.isCreateTargetDirectory());
        artifactCopyStep.setTargetFileName(this.resolveTargetFileName());
        artifactCopyStep.setSourceFileDescription(((DeployableArtifact)this.getDeployable()).getName());
        if (!this.useDescriptionGeneratedByStep) {
            artifactCopyStep.setDescription(this.getDescription(this.getCreateVerb()));
        }
        return artifactCopyStep;
    }

    @Modify
    public void executeModify(DeploymentPlanningContext deploymentPlanningContext, Delta delta) {
        CopiedArtifact copiedArtifact = (CopiedArtifact)delta.getPrevious();
        copiedArtifact.executeDestroy(deploymentPlanningContext);
        this.executeCreate(deploymentPlanningContext);
    }

    @Destroy
    public void executeDestroy(DeploymentPlanningContext deploymentPlanningContext) {
        deploymentPlanningContext.addStep((DeploymentStep)this.createArtifactDeleteStep());
    }

    protected ArtifactDeleteStep createArtifactDeleteStep() {
        ArtifactDeleteStep artifactDeleteStep = new ArtifactDeleteStep(this.getDestroyOrder(), (HostContainer)this.getContainer(), (DeployableArtifact)this.getDeployable(), this.getTargetDirectory());
        artifactDeleteStep.setTargetDirectoryShared(this.isTargetDirectoryShared());
        artifactDeleteStep.setTargetFile(this.resolveTargetFileName());
        if (!this.useDescriptionGeneratedByStep) {
            artifactDeleteStep.setDescription(this.getDescription(this.getDestroyVerb()));
        }
        return artifactDeleteStep;
    }

    public void setUseDescriptionGeneratedByStep(boolean bl) {
        this.useDescriptionGeneratedByStep = bl;
    }
}

