/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.step;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.generic.step.BaseStep;
import com.xebialabs.deployit.plugin.overthere.AutoFlushingExecutionContextOverthereProcessOutputHandler;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.remoting.scripts.ScriptUtils;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class BaseExecutionStep<C extends ExecutionContext>
extends BaseStep<C> {
    private static final String MDC_KEY_SCRIPT_PATH = "scriptPath";
    private String scriptTemplatePath;
    private Map<String, Object> vars;
    private File artifact;
    private List<File> fileResources = Lists.newArrayList();
    private List<String> classpathResources = Lists.newArrayList();
    private List<String> templateClasspathResources = Lists.newArrayList();
    private static final Logger scriptsLogger = LoggerFactory.getLogger((String)"com.xebialabs.deployit.plugin.generic.scripts");

    public BaseExecutionStep(String string, HostContainer hostContainer, Map<String, Object> map, String string2) {
        super(string2, hostContainer);
        this.scriptTemplatePath = string;
        this.vars = Maps.newHashMap(map);
        this.vars.put("step", this);
        Preconditions.checkNotNull((Object)this.scriptTemplatePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Step.Result doExecute() throws Exception {
        MDC.put((String)MDC_KEY_SCRIPT_PATH, (String)this.scriptTemplatePath);
        try {
            this.uploadArtifactIfPresent();
            this.uploadFileResources();
            this.uploadClasspathResources();
            this.uploadTemplateClasspathResources();
            OverthereFile overthereFile = this.uploadScriptToExecute(this.scriptTemplatePath);
            this.setWorkingDirectory();
            Step.Result result = this.executeScript(overthereFile);
            return result;
        }
        finally {
            MDC.remove((String)MDC_KEY_SCRIPT_PATH);
        }
    }

    protected OverthereFile uploadArtifactIfPresent() {
        if (this.artifact != null) {
            return this.uploadToWorkingDirectory(this.artifact, this.artifact.getName());
        }
        return null;
    }

    protected void uploadFileResources() {
        for (File file : this.fileResources) {
            this.uploadToWorkingDirectory(file, file.getName());
        }
    }

    protected void uploadClasspathResources() {
        for (String string : this.classpathResources) {
            String string2 = this.substringAfterLast(string, '/', string);
            this.uploadToWorkingDirectory(Resources.getResource((String)string), string2);
        }
    }

    protected void uploadTemplateClasspathResources() {
        for (String string : this.templateClasspathResources) {
            this.uploadTemplateResourceToWorkingDirectory(string, null);
        }
    }

    protected void setWorkingDirectory() {
        this.getRemoteConnection().setWorkingDirectory(this.getRemoteWorkingDirectory());
    }

    protected OverthereFile uploadScriptToExecute(String string) {
        OverthereFile overthereFile = this.uploadTemplateResourceToWorkingDirectory(string, scriptsLogger);
        overthereFile.setExecutable(true);
        return overthereFile;
    }

    private OverthereFile uploadTemplateResourceToWorkingDirectory(String string, Logger logger) {
        String string2 = this.resolveOsSpecificTemplate(string);
        String string3 = this.evaluateTemplate(string2, this.vars);
        if (logger != null) {
            ScriptUtils.dumpScript((String)string2, (String)string3, (Logger)logger);
        }
        String string4 = this.resolveOsSpecificFileName(string2);
        return this.uploadToWorkingDirectory(string3, string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Step.Result executeScript(OverthereFile overthereFile) {
        CmdLine cmdLine = CmdLine.build((String[])new String[]{overthereFile.getPath()});
        AutoFlushingExecutionContextOverthereProcessOutputHandler autoFlushingExecutionContextOverthereProcessOutputHandler = new AutoFlushingExecutionContextOverthereProcessOutputHandler(this.getCtx());
        try {
            this.getCtx().logOutput("Executing " + overthereFile.getPath() + " on host " + this.getContainer().getHost());
            int n = this.getRemoteConnection().execute((OverthereProcessOutputHandler)autoFlushingExecutionContextOverthereProcessOutputHandler, cmdLine);
            if (n != 0) {
                this.getCtx().logError("Execution failed with return code " + n);
                Step.Result result = Step.Result.Fail;
                return result;
            }
            Step.Result result = Step.Result.Success;
            return result;
        }
        finally {
            autoFlushingExecutionContextOverthereProcessOutputHandler.close();
        }
    }

    public List<File> getFileResources() {
        return this.fileResources;
    }

    public void setFileResources(List<File> list) {
        this.fileResources = list;
    }

    public List<String> getClasspathResources() {
        return this.classpathResources;
    }

    public void setClasspathResources(List<String> list) {
        this.classpathResources = list;
    }

    public List<String> getTemplateClasspathResources() {
        return this.templateClasspathResources;
    }

    public void setTemplateClasspathResources(List<String> list) {
        this.templateClasspathResources = list;
    }

    public File getArtifact() {
        return this.artifact;
    }

    public void setArtifact(File file) {
        this.artifact = file;
    }

    public String getUploadedArtifactPath() {
        if (this.artifact != null) {
            return this.getRemoteWorkingDirectory().getPath() + this.getContainer().getHost().getOs().getFileSeparator() + this.artifact.getName();
        }
        return null;
    }

    protected String resolveOsSpecificFileName(String string) {
        String string2;
        String string3 = this.substringAfterLast(string, '/', string);
        if (string3.endsWith(".ftl")) {
            string3 = string3.substring(0, string3.lastIndexOf(".ftl"));
        }
        if ((string2 = this.substringAfterLast(string3, '.')) == null) {
            OperatingSystemFamily operatingSystemFamily = this.getContainer().getHost().getOs();
            string3 = string3 + operatingSystemFamily.getScriptExtension();
        }
        return string3;
    }
}

