/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.SortedMap;
import java.util.regex.Pattern;

class PathMapper {
    private static final String DRIVE_DESIGNATOR = ":";
    private static final String ADMIN_SHARE_DESIGNATOR = "$";
    private static final Pattern ADMIN_SHARE_PATTERN = Pattern.compile("[a-zA-Z]" + Pattern.quote("$"));
    private final SortedMap<String, String> sharesForPaths;
    private final Map<String, String> pathsForShares;

    @VisibleForTesting
    PathMapper(Map<String, String> map) {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.reverseOrder();
        ImmutableMap.Builder builder2 = ImmutableMap.builder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            builder.put((Object)string.toLowerCase(), (Object)string2);
            builder2.put((Object)string2.toLowerCase(), (Object)string);
        }
        this.sharesForPaths = builder.build();
        this.pathsForShares = builder2.build();
    }

    @VisibleForTesting
    String toSharedPath(String string) {
        final String string2 = string.toLowerCase();
        String string3 = (String)Iterables.find(this.sharesForPaths.keySet(), (Predicate)new Predicate<String>(){

            public boolean apply(String string) {
                return string2.startsWith(string);
            }
        }, null);
        return string3 != null ? (String)this.sharesForPaths.get(string3) + string.substring(string3.length()) : string.substring(0, 1) + ADMIN_SHARE_DESIGNATOR + string.substring(2);
    }

    @VisibleForTesting
    String toLocalPath(String string) {
        final String string2 = string.toLowerCase();
        String string3 = (String)Iterables.find(this.pathsForShares.keySet(), (Predicate)new Predicate<String>(){

            public boolean apply(String string) {
                return string2.startsWith(string);
            }
        }, null);
        if (string3 != null) {
            return this.pathsForShares.get(string3) + string.substring(string3.length());
        }
        if (string.length() >= 2 && ADMIN_SHARE_PATTERN.matcher(string.substring(0, 2)).matches()) {
            return string.substring(0, 1) + DRIVE_DESIGNATOR + string.substring(2);
        }
        throw new IllegalArgumentException(String.format("Remote path name '%s' uses unrecognized (i.e. neither mapped nor administrative) share", string));
    }
}

