/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.local;

import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.Overthere;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.spi.BaseOverthereConnection;
import com.xebialabs.overthere.spi.OverthereConnectionBuilder;
import com.xebialabs.overthere.spi.Protocol;
import com.xebialabs.overthere.util.DefaultAddressPortMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Protocol(name="local")
public class LocalConnection
extends BaseOverthereConnection
implements OverthereConnectionBuilder {
    public static final String LOCAL_PROTOCOL = "local";
    private static final Logger logger = LoggerFactory.getLogger(LocalConnection.class);

    public LocalConnection(String string, ConnectionOptions connectionOptions, AddressPortMapper addressPortMapper) {
        super(string, LocalConnection.fixOptions(connectionOptions), addressPortMapper, true);
    }

    public LocalConnection(String string, ConnectionOptions connectionOptions) {
        this(string, connectionOptions, new DefaultAddressPortMapper());
    }

    private static ConnectionOptions fixOptions(ConnectionOptions connectionOptions) {
        connectionOptions = new ConnectionOptions(connectionOptions);
        connectionOptions.set("os", (Object)OperatingSystemFamily.getLocalHostOperatingSystemFamily());
        if (connectionOptions.getOptional("tmp") == null) {
            connectionOptions.set("tmp", System.getProperty("java.io.tmpdir"));
        }
        return connectionOptions;
    }

    @Override
    public OverthereConnection connect() {
        return this;
    }

    @Override
    public void doClose() {
    }

    @Override
    public OverthereFile getFile(String string) throws RuntimeIOException {
        return new LocalFile(this, new File(string));
    }

    @Override
    public OverthereFile getFile(OverthereFile overthereFile, String string) throws RuntimeIOException {
        if (!(overthereFile instanceof LocalFile)) {
            throw new IllegalStateException("parent is not a LocalOverthereFile");
        }
        File file = new File(((LocalFile)overthereFile).getFile(), string);
        return new LocalFile(this, file);
    }

    @Override
    protected OverthereFile getFileForTempFile(OverthereFile overthereFile, String string) {
        return this.getFile(overthereFile, string);
    }

    @Override
    public OverthereProcess startProcess(CmdLine cmdLine) {
        logger.info("Executing command {} on {}", (Object)cmdLine, (Object)this);
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(cmdLine.toCommandArray(this.os, false));
            if (this.workingDirectory != null) {
                processBuilder.directory(((LocalFile)this.workingDirectory).getFile());
            }
            final Process process = processBuilder.start();
            return new OverthereProcess(){

                @Override
                public OutputStream getStdin() {
                    return process.getOutputStream();
                }

                @Override
                public InputStream getStdout() {
                    return process.getInputStream();
                }

                @Override
                public InputStream getStderr() {
                    return process.getErrorStream();
                }

                @Override
                public int waitFor() throws InterruptedException {
                    return process.waitFor();
                }

                @Override
                public void destroy() {
                    process.destroy();
                }
            };
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Cannot start process for " + cmdLine, iOException);
        }
    }

    @Override
    public String toString() {
        return "local:";
    }

    public static OverthereConnection getLocalConnection() {
        return Overthere.getConnection(LOCAL_PROTOCOL, new ConnectionOptions());
    }
}

